/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.ratelimiter.operator;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.reactor.ratelimiter.operator.FluxRateLimiter;
import io.github.resilience4j.reactor.ratelimiter.operator.MonoRateLimiter;
import java.util.function.UnaryOperator;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class RateLimiterOperator<T>
implements UnaryOperator<Publisher<T>> {
    private final RateLimiter rateLimiter;
    private final Scheduler scheduler;

    private RateLimiterOperator(RateLimiter rateLimiter, Scheduler scheduler) {
        this.rateLimiter = rateLimiter;
        this.scheduler = scheduler;
    }

    public static <T> RateLimiterOperator<T> of(RateLimiter rateLimiter) {
        return RateLimiterOperator.of(rateLimiter, Schedulers.parallel());
    }

    public static <T> RateLimiterOperator<T> of(RateLimiter rateLimiter, Scheduler scheduler) {
        return new RateLimiterOperator<T>(rateLimiter, scheduler);
    }

    @Override
    public Publisher<T> apply(Publisher<T> publisher) {
        if (publisher instanceof Mono) {
            return new MonoRateLimiter((Mono)publisher, this.rateLimiter, this.scheduler);
        }
        if (publisher instanceof Flux) {
            return new FluxRateLimiter((Flux)publisher, this.rateLimiter, this.scheduler);
        }
        throw new IllegalStateException("Publisher of type <" + publisher.getClass().getSimpleName() + "> are not supported by this operator");
    }
}

