/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.bulkhead.operator;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.github.resilience4j.reactor.bulkhead.operator.BulkheadSubscriber;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;
import reactor.core.publisher.Operators;

class MonoBulkhead<T>
extends MonoOperator<T, T> {
    private final Bulkhead bulkhead;

    MonoBulkhead(Mono<? extends T> source, Bulkhead bulkhead) {
        super(source);
        this.bulkhead = bulkhead;
    }

    public void subscribe(CoreSubscriber<? super T> actual) {
        if (this.bulkhead.tryAcquirePermission()) {
            this.source.subscribe(new BulkheadSubscriber<T>(this.bulkhead, actual, true));
        } else {
            Operators.error(actual, (Throwable)BulkheadFullException.createBulkheadFullException((Bulkhead)this.bulkhead));
        }
    }
}

