/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retrofit;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.retrofit.RetrofitRateLimiter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Retrofit;

public final class RateLimiterCallAdapter
extends CallAdapter.Factory {
    private final RateLimiter rateLimiter;

    private RateLimiterCallAdapter(RateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    public static RateLimiterCallAdapter of(RateLimiter rateLimiter) {
        return new RateLimiterCallAdapter(rateLimiter);
    }

    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        final CallAdapter nextAdapter = retrofit.nextCallAdapter((CallAdapter.Factory)this, returnType, annotations);
        return new CallAdapter<Object, Object>(){

            public Type responseType() {
                return nextAdapter.responseType();
            }

            public Object adapt(Call<Object> call) {
                return nextAdapter.adapt(RetrofitRateLimiter.decorateCall(RateLimiterCallAdapter.this.rateLimiter, call));
            }
        };
    }
}

