/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retrofit;

import io.github.resilience4j.retrofit.internal.DecoratedCall;
import io.github.resilience4j.retry.Retry;
import java.io.IOException;
import okhttp3.Request;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public interface RetrofitRetry {
    public static <T> Call<T> decorateCall(Retry retry, Call<T> call) {
        return new RetryCall<T>(call, retry);
    }

    public static class RetryCall<T>
    extends DecoratedCall<T> {
        private final Call<T> call;
        private final Retry retry;
        private final Retry.Context<Response<T>> context;

        public RetryCall(Call<T> call, Retry retry) {
            super(call);
            this.call = call;
            this.retry = retry;
            this.context = retry.context();
        }

        private Callback<T> retriedCallback(final Callback<T> callback) {
            return new Callback<T>(){

                public void onResponse(Call<T> call, Response<T> response) {
                    if (context.onResult(response)) {
                        this.executableCall().enqueue(this.retriedCallback(callback));
                    } else {
                        context.onComplete();
                        callback.onResponse(call, response);
                    }
                }

                public void onFailure(Call<T> call, Throwable throwable) {
                    try {
                        context.onError(this.asException(throwable));
                        this.executableCall().enqueue(this.retriedCallback(callback));
                    }
                    catch (Exception exception) {
                        callback.onFailure(call, (Throwable)exception);
                    }
                }

                private Exception asException(Throwable throwable) {
                    return throwable instanceof Exception ? (Exception)throwable : new RuntimeException("Throwable", throwable);
                }
            };
        }

        @Override
        public void enqueue(Callback<T> callback) {
            this.call.enqueue(this.retriedCallback(callback));
        }

        @Override
        public Response<T> execute() throws IOException {
            Response response = null;
            try {
                response = (Response)this.retry.executeCallable(() -> this.executableCall().execute());
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Throwable t) {
                throw new RuntimeException("Exception executing call", t);
            }
            return response;
        }

        private Call<T> executableCall() {
            if (this.call.isExecuted()) {
                return this.call.clone();
            }
            return this.call;
        }

        @Override
        public Call<T> clone() {
            return new RetryCall<T>(this.executableCall(), this.retry);
        }

        @Override
        public boolean isExecuted() {
            return this.call.isExecuted();
        }

        @Override
        public boolean isCanceled() {
            return this.call.isCanceled();
        }

        @Override
        public void cancel() {
            this.call.cancel();
        }

        @Override
        public Request request() {
            return this.call.request();
        }
    }
}

