/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry;

import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.event.RetryEvent;
import io.github.resilience4j.retry.event.RetryOnErrorEvent;
import io.github.resilience4j.retry.event.RetryOnIgnoredErrorEvent;
import io.github.resilience4j.retry.event.RetryOnSuccessEvent;
import io.github.resilience4j.retry.internal.RetryImpl;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedRunnable;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Retry {
    public String getName();

    public Context context();

    public RetryConfig getRetryConfig();

    public EventPublisher getEventPublisher();

    public static Retry of(String name, RetryConfig retryConfig) {
        return new RetryImpl(name, retryConfig);
    }

    public static Retry of(String name, Supplier<RetryConfig> retryConfigSupplier) {
        return new RetryImpl(name, retryConfigSupplier.get());
    }

    public static Retry ofDefaults(String name) {
        return new RetryImpl(name, RetryConfig.ofDefaults());
    }

    default public <T> T executeSupplier(Supplier<T> supplier) {
        return Retry.decorateSupplier(this, supplier).get();
    }

    default public <T> T executeCallable(Callable<T> callable) throws Exception {
        return Retry.decorateCallable(this, callable).call();
    }

    default public void executeRunnable(Runnable runnable) {
        Retry.decorateRunnable(this, runnable).run();
    }

    public static <T> CheckedFunction0<T> decorateCheckedSupplier(Retry retry, CheckedFunction0<T> supplier) {
        return (CheckedFunction0 & Serializable)() -> {
            Context context = retry.context();
            while (true) {
                try {
                    Object result = supplier.apply();
                    context.onSuccess();
                    return result;
                }
                catch (Exception exception) {
                    context.onError(exception);
                    continue;
                }
                break;
            }
        };
    }

    public static CheckedRunnable decorateCheckedRunnable(Retry retry, CheckedRunnable runnable) {
        return () -> {
            Context context = retry.context();
            while (true) {
                try {
                    runnable.run();
                    context.onSuccess();
                }
                catch (Exception exception) {
                    context.onError(exception);
                    continue;
                }
                break;
            }
        };
    }

    public static <T, R> CheckedFunction1<T, R> decorateCheckedFunction(Retry retry, CheckedFunction1<T, R> function) {
        return (CheckedFunction1 & Serializable)t -> {
            Context context = retry.context();
            while (true) {
                try {
                    Object result = function.apply(t);
                    context.onSuccess();
                    return result;
                }
                catch (Exception exception) {
                    context.onError(exception);
                    continue;
                }
                break;
            }
        };
    }

    public static <T> Supplier<T> decorateSupplier(Retry retry, Supplier<T> supplier) {
        return () -> {
            Context context = retry.context();
            while (true) {
                try {
                    Object result = supplier.get();
                    context.onSuccess();
                    return result;
                }
                catch (RuntimeException runtimeException) {
                    context.onRuntimeError(runtimeException);
                    continue;
                }
                break;
            }
        };
    }

    public static <T> Callable<T> decorateCallable(Retry retry, Callable<T> supplier) {
        return () -> {
            Context context = retry.context();
            while (true) {
                try {
                    Object result = supplier.call();
                    context.onSuccess();
                    return result;
                }
                catch (RuntimeException runtimeException) {
                    context.onRuntimeError(runtimeException);
                    continue;
                }
                break;
            }
        };
    }

    public static Runnable decorateRunnable(Retry retry, Runnable runnable) {
        return () -> {
            Context context = retry.context();
            while (true) {
                try {
                    runnable.run();
                    context.onSuccess();
                }
                catch (RuntimeException runtimeException) {
                    context.onRuntimeError(runtimeException);
                    continue;
                }
                break;
            }
        };
    }

    public static <T, R> Function<T, R> decorateFunction(Retry retry, Function<T, R> function) {
        return t -> {
            Context context = retry.context();
            while (true) {
                try {
                    Object result = function.apply(t);
                    context.onSuccess();
                    return result;
                }
                catch (RuntimeException runtimeException) {
                    context.onRuntimeError(runtimeException);
                    continue;
                }
                break;
            }
        };
    }

    public Metrics getMetrics();

    public static interface EventPublisher
    extends io.github.resilience4j.core.EventPublisher<RetryEvent> {
        public EventPublisher onSuccess(EventConsumer<RetryOnSuccessEvent> var1);

        public EventPublisher onError(EventConsumer<RetryOnErrorEvent> var1);

        public EventPublisher onIgnoredError(EventConsumer<RetryOnIgnoredErrorEvent> var1);
    }

    public static interface Context {
        public void onSuccess();

        public void onError(Exception var1) throws Throwable;

        public void onRuntimeError(RuntimeException var1);
    }

    public static interface Metrics {
        public long getNumberOfSuccessfulCallsWithoutRetryAttempt();

        public long getNumberOfFailedCallsWithoutRetryAttempt();

        public long getNumberOfSuccessfulCallsWithRetryAttempt();

        public long getNumberOfFailedCallsWithRetryAttempt();
    }
}

