/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.event;

import io.github.resilience4j.retry.event.AbstractRetryEvent;
import io.github.resilience4j.retry.event.RetryEvent;
import java.time.Duration;

public class RetryOnRetryEvent
extends AbstractRetryEvent {
    private final Duration waitInterval;

    public RetryOnRetryEvent(String name, int numberOfAttempts, Throwable lastThrowable, long waitInterval) {
        super(name, numberOfAttempts, lastThrowable);
        this.waitInterval = Duration.ofMillis(waitInterval);
    }

    @Override
    public RetryEvent.Type getEventType() {
        return RetryEvent.Type.RETRY;
    }

    public String toString() {
        return String.format("%s: Retry '%s', waiting %s until attempt #%d. Last attempt failed with exception %s", this.getCreationTime(), this.getName(), this.waitInterval, this.getNumberOfRetryAttempts(), this.getLastThrowable().toString());
    }
}

