/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry;

import io.github.resilience4j.retry.AsyncRetryBlock;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.event.RetryEvent;
import io.github.resilience4j.retry.internal.AsyncRetryContext;
import io.reactivex.Flowable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;

public interface AsyncRetry {
    public String getName();

    public void onSuccess();

    public long onError(Throwable var1);

    public Flowable<RetryEvent> getEventStream();

    public static AsyncRetry of(String id, RetryConfig retryConfig) {
        return new AsyncRetryContext(id, retryConfig);
    }

    public static AsyncRetry of(String id, Supplier<RetryConfig> retryConfigSupplier) {
        return AsyncRetry.of(id, retryConfigSupplier.get());
    }

    public static AsyncRetry ofDefaults(String id) {
        return AsyncRetry.of(id, RetryConfig.ofDefaults());
    }

    public static <T> Supplier<CompletionStage<T>> decorateCompletionStage(AsyncRetry retryContext, ScheduledExecutorService scheduler, Supplier<CompletionStage<T>> supplier) {
        return () -> {
            CompletableFuture promise = new CompletableFuture();
            AsyncRetryBlock block = new AsyncRetryBlock(scheduler, retryContext, supplier, promise);
            block.run();
            return promise;
        };
    }

    public Metrics getMetrics();

    public static interface Metrics {
        public int getNumAttempts();

        public int getMaxAttempts();
    }
}

