/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry;

final class IntervalFunctionCompanion {
    private IntervalFunctionCompanion() {
    }

    static double randomize(double current, double randomizationFactor) {
        double delta = randomizationFactor * current;
        double min = current - delta;
        double max = current + delta;
        return min + Math.random() * (max - min + 1.0);
    }

    static void checkInterval(long v) {
        if (v < 10L) {
            throw new IllegalArgumentException("Illegal argument interval: " + v + " millis");
        }
    }

    static void checkMultiplier(double v) {
        if (v < 1.0) {
            throw new IllegalArgumentException("Illegal argument multiplier: " + v);
        }
    }

    static void checkRandomizationFactor(double v) {
        if (v < 0.0 || v >= 1.0) {
            throw new IllegalArgumentException("Illegal argument randomizationFactor: " + v);
        }
    }

    static void checkAttempt(long v) {
        if (v < 1L) {
            throw new IllegalArgumentException("Illegal argument attempt: " + v);
        }
    }
}

