/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry;

import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.event.RetryEvent;
import io.github.resilience4j.retry.internal.RetryContext;
import io.reactivex.Flowable;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedRunnable;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Retry {
    public String getName();

    public void onSuccess();

    public void onError(Exception var1) throws Throwable;

    public void onRuntimeError(RuntimeException var1);

    public Flowable<RetryEvent> getEventStream();

    public static RetryContext of(String name, RetryConfig retryConfig) {
        return new RetryContext(name, retryConfig);
    }

    public static RetryContext of(String name, Supplier<RetryConfig> retryConfigSupplier) {
        return new RetryContext(name, retryConfigSupplier.get());
    }

    public static Retry ofDefaults(String name) {
        return new RetryContext(name, RetryConfig.ofDefaults());
    }

    default public <T> T executeSupplier(Supplier<T> supplier) {
        return Retry.decorateSupplier(this, supplier).get();
    }

    default public <T> T executeCallable(Callable<T> callable) throws Exception {
        return Retry.decorateCallable(this, callable).call();
    }

    default public void executeRunnable(Runnable runnable) {
        Retry.decorateRunnable(this, runnable).run();
    }

    public static <T> CheckedFunction0<T> decorateCheckedSupplier(Retry retryContext, CheckedFunction0<T> supplier) {
        return (CheckedFunction0 & Serializable)() -> {
            while (true) {
                try {
                    Object result = supplier.apply();
                    retryContext.onSuccess();
                    return result;
                }
                catch (Exception exception) {
                    retryContext.onError(exception);
                    continue;
                }
                break;
            }
        };
    }

    public static CheckedRunnable decorateCheckedRunnable(Retry retryContext, CheckedRunnable runnable) {
        return () -> {
            while (true) {
                try {
                    runnable.run();
                    retryContext.onSuccess();
                }
                catch (Exception exception) {
                    retryContext.onError(exception);
                    continue;
                }
                break;
            }
        };
    }

    public static <T, R> CheckedFunction1<T, R> decorateCheckedFunction(Retry retryContext, CheckedFunction1<T, R> function) {
        return (CheckedFunction1 & Serializable)t -> {
            while (true) {
                try {
                    Object result = function.apply(t);
                    retryContext.onSuccess();
                    return result;
                }
                catch (Exception exception) {
                    retryContext.onError(exception);
                    continue;
                }
                break;
            }
        };
    }

    public static <T> Supplier<T> decorateSupplier(Retry retryContext, Supplier<T> supplier) {
        return () -> {
            while (true) {
                try {
                    Object result = supplier.get();
                    retryContext.onSuccess();
                    return result;
                }
                catch (RuntimeException runtimeException) {
                    retryContext.onRuntimeError(runtimeException);
                    continue;
                }
                break;
            }
        };
    }

    public static <T> Callable<T> decorateCallable(Retry retryContext, Callable<T> supplier) {
        return () -> {
            while (true) {
                try {
                    Object result = supplier.call();
                    retryContext.onSuccess();
                    return result;
                }
                catch (RuntimeException runtimeException) {
                    retryContext.onRuntimeError(runtimeException);
                    continue;
                }
                break;
            }
        };
    }

    public static Runnable decorateRunnable(Retry retryContext, Runnable runnable) {
        return () -> {
            while (true) {
                try {
                    runnable.run();
                    retryContext.onSuccess();
                }
                catch (RuntimeException runtimeException) {
                    retryContext.onRuntimeError(runtimeException);
                    continue;
                }
                break;
            }
        };
    }

    public static <T, R> Function<T, R> decorateFunction(Retry retryContext, Function<T, R> function) {
        return t -> {
            while (true) {
                try {
                    Object result = function.apply(t);
                    retryContext.onSuccess();
                    return result;
                }
                catch (RuntimeException runtimeException) {
                    retryContext.onRuntimeError(runtimeException);
                    continue;
                }
                break;
            }
        };
    }

    public Metrics getMetrics();

    public static interface Metrics {
        public int getNumAttempts();

        public int getMaxAttempts();
    }
}

