/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.internal;

import io.github.resilience4j.retry.AsyncRetry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.event.RetryEvent;
import io.github.resilience4j.retry.event.RetryOnErrorEvent;
import io.github.resilience4j.retry.event.RetryOnSuccessEvent;
import io.reactivex.Flowable;
import io.reactivex.processors.FlowableProcessor;
import io.reactivex.processors.PublishProcessor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class AsyncRetryContext
implements AsyncRetry {
    private final String name;
    private final int maxAttempts;
    private final Function<Integer, Long> intervalFunction;
    private final AsyncRetry.Metrics metrics;
    private final FlowableProcessor<RetryEvent> eventPublisher;
    private final Predicate<Throwable> exceptionPredicate;
    private final AtomicInteger numOfAttempts = new AtomicInteger(0);

    public AsyncRetryContext(String name, RetryConfig config) {
        this.name = name;
        this.maxAttempts = config.getMaxAttempts();
        this.intervalFunction = config.getIntervalFunction();
        this.exceptionPredicate = config.getExceptionPredicate();
        PublishProcessor publisher = PublishProcessor.create();
        this.eventPublisher = publisher.toSerialized();
        this.metrics = new AsyncRetryContextMetrics();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void onSuccess() {
        int currentNumOfAttempts = this.numOfAttempts.get();
        this.publishRetryEvent(() -> new RetryOnSuccessEvent(this.name, currentNumOfAttempts, null));
    }

    @Override
    public long onError(Throwable throwable) {
        if (!this.exceptionPredicate.test(throwable)) {
            return -1L;
        }
        int attempt = this.numOfAttempts.addAndGet(1);
        if (attempt > this.maxAttempts) {
            return -1L;
        }
        this.publishRetryEvent(() -> new RetryOnErrorEvent(this.name, attempt, throwable));
        return this.intervalFunction.apply(attempt);
    }

    @Override
    public Flowable<RetryEvent> getEventStream() {
        return this.eventPublisher;
    }

    private void publishRetryEvent(Supplier<RetryEvent> event) {
        if (this.eventPublisher.hasSubscribers()) {
            this.eventPublisher.onNext((Object)event.get());
        }
    }

    @Override
    public AsyncRetry.Metrics getMetrics() {
        return this.metrics;
    }

    public final class AsyncRetryContextMetrics
    implements AsyncRetry.Metrics {
        private AsyncRetryContextMetrics() {
        }

        @Override
        public int getNumAttempts() {
            return AsyncRetryContext.this.numOfAttempts.get();
        }

        @Override
        public int getMaxAttempts() {
            return AsyncRetryContext.this.maxAttempts;
        }
    }
}

