/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.internal;

import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.event.RetryEvent;
import io.github.resilience4j.retry.event.RetryOnErrorEvent;
import io.github.resilience4j.retry.event.RetryOnSuccessEvent;
import io.reactivex.Flowable;
import io.reactivex.processors.FlowableProcessor;
import io.reactivex.processors.PublishProcessor;
import io.vavr.CheckedConsumer;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class RetryContext
implements Retry {
    private final AtomicInteger numOfAttempts = new AtomicInteger(0);
    private AtomicReference<Exception> lastException = new AtomicReference();
    private AtomicReference<RuntimeException> lastRuntimeException = new AtomicReference();
    private final Retry.Metrics metrics;
    private final FlowableProcessor<RetryEvent> eventPublisher;
    private String name;
    private int maxAttempts;
    private Function<Integer, Long> intervalFunction;
    private Predicate<Throwable> exceptionPredicate;
    static CheckedConsumer<Long> sleepFunction = Thread::sleep;

    public RetryContext(String name, RetryConfig config) {
        this.name = name;
        this.maxAttempts = config.getMaxAttempts();
        this.intervalFunction = config.getIntervalFunction();
        this.exceptionPredicate = config.getExceptionPredicate();
        PublishProcessor publisher = PublishProcessor.create();
        this.metrics = new RetryContextMetrics();
        this.eventPublisher = publisher.toSerialized();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void onSuccess() {
        int currentNumOfAttempts = this.numOfAttempts.get();
        if (currentNumOfAttempts > 0) {
            Throwable throwable = (Throwable)Option.of((Object)this.lastException.get()).getOrElse((Object)this.lastRuntimeException.get());
            this.publishRetryEvent(() -> new RetryOnSuccessEvent(this.getName(), currentNumOfAttempts, throwable));
        }
    }

    private void throwOrSleepAfterException() throws Exception {
        int currentNumOfAttempts = this.numOfAttempts.incrementAndGet();
        if (currentNumOfAttempts >= this.maxAttempts) {
            Exception throwable = this.lastException.get();
            this.publishRetryEvent(() -> new RetryOnErrorEvent(this.getName(), currentNumOfAttempts, throwable));
            throw throwable;
        }
        this.waitIntervalAfterFailure();
    }

    private void throwOrSleepAfterRuntimeException() {
        int currentNumOfAttempts = this.numOfAttempts.incrementAndGet();
        if (currentNumOfAttempts >= this.maxAttempts) {
            RuntimeException throwable = this.lastRuntimeException.get();
            this.publishRetryEvent(() -> new RetryOnErrorEvent(this.getName(), currentNumOfAttempts, throwable));
            throw throwable;
        }
        this.waitIntervalAfterFailure();
    }

    private void waitIntervalAfterFailure() {
        long interval = this.intervalFunction.apply(this.numOfAttempts.get());
        Try.run(() -> sleepFunction.accept((Object)interval)).getOrElseThrow(ex -> this.lastRuntimeException.get());
    }

    @Override
    public void onError(Exception exception) throws Throwable {
        if (!this.exceptionPredicate.test(exception)) {
            throw exception;
        }
        this.lastException.set(exception);
        this.throwOrSleepAfterException();
    }

    @Override
    public void onRuntimeError(RuntimeException runtimeException) {
        if (!this.exceptionPredicate.test(runtimeException)) {
            throw runtimeException;
        }
        this.lastRuntimeException.set(runtimeException);
        this.throwOrSleepAfterRuntimeException();
    }

    private void publishRetryEvent(Supplier<RetryEvent> event) {
        if (this.eventPublisher.hasSubscribers()) {
            this.eventPublisher.onNext((Object)event.get());
        }
    }

    @Override
    public Flowable<RetryEvent> getEventStream() {
        return this.eventPublisher;
    }

    @Override
    public Retry.Metrics getMetrics() {
        return this.metrics;
    }

    public final class RetryContextMetrics
    implements Retry.Metrics {
        private RetryContextMetrics() {
        }

        @Override
        public int getNumAttempts() {
            return RetryContext.this.numOfAttempts.get();
        }

        @Override
        public int getMaxAttempts() {
            return RetryContext.this.maxAttempts;
        }
    }
}

