/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry;

import io.github.resilience4j.core.Registry;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.internal.InMemoryRetryRegistry;
import io.vavr.collection.Seq;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public interface RetryRegistry
extends Registry<Retry, RetryConfig> {
    public Seq<Retry> getAllRetries();

    public Retry retry(String var1);

    public Retry retry(String var1, RetryConfig var2);

    public Retry retry(String var1, Supplier<RetryConfig> var2);

    public Retry retry(String var1, String var2);

    public static RetryRegistry of(RetryConfig retryConfig) {
        return new InMemoryRetryRegistry(retryConfig);
    }

    public static RetryRegistry of(RetryConfig retryConfig, RegistryEventConsumer<Retry> registryEventConsumer) {
        return new InMemoryRetryRegistry(retryConfig, registryEventConsumer);
    }

    public static RetryRegistry of(RetryConfig retryConfig, List<RegistryEventConsumer<Retry>> registryEventConsumers) {
        return new InMemoryRetryRegistry(retryConfig, registryEventConsumers);
    }

    public static RetryRegistry ofDefaults() {
        return new InMemoryRetryRegistry();
    }

    public static RetryRegistry of(Map<String, RetryConfig> configs) {
        return new InMemoryRetryRegistry(configs);
    }

    public static RetryRegistry of(Map<String, RetryConfig> configs, RegistryEventConsumer<Retry> registryEventConsumer) {
        return new InMemoryRetryRegistry(configs, registryEventConsumer);
    }

    public static RetryRegistry of(Map<String, RetryConfig> configs, List<RegistryEventConsumer<Retry>> registryEventConsumers) {
        return new InMemoryRetryRegistry(configs, registryEventConsumers);
    }
}

