/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.monitoring.health;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import java.util.Optional;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

public class CircuitBreakerHealthIndicator
implements HealthIndicator {
    private static final String FAILURE_RATE = "failureRate";
    private static final String FAILURE_RATE_THRESHOLD = "setFailureRateThreshold";
    private static final String BUFFERED_CALLS = "bufferedCalls";
    private static final String FAILED_CALLS = "failedCalls";
    private static final String NOT_PERMITTED = "notPermittedCalls";
    private static final String MAX_BUFFERED_CALLS = "maxBufferedCalls";
    private static final String STATE = "state";
    private final CircuitBreaker circuitBreaker;

    public CircuitBreakerHealthIndicator(CircuitBreaker circuitBreaker) {
        this.circuitBreaker = circuitBreaker;
    }

    public Health health() {
        return Optional.of(this.circuitBreaker).map(this::mapBackendMonitorState).orElse(Health.up().build());
    }

    private Health mapBackendMonitorState(CircuitBreaker circuitBreaker) {
        switch (circuitBreaker.getState()) {
            case CLOSED: {
                return this.addDetails(Health.up(), circuitBreaker).build();
            }
            case OPEN: {
                return this.addDetails(Health.down(), circuitBreaker).build();
            }
            case HALF_OPEN: {
                return this.addDetails(Health.unknown(), circuitBreaker).build();
            }
        }
        return this.addDetails(Health.unknown(), circuitBreaker).build();
    }

    private Health.Builder addDetails(Health.Builder builder, CircuitBreaker circuitBreaker) {
        CircuitBreaker.Metrics metrics = circuitBreaker.getMetrics();
        CircuitBreakerConfig config = circuitBreaker.getCircuitBreakerConfig();
        builder.withDetail(FAILURE_RATE, (Object)(metrics.getFailureRate() + "%")).withDetail(FAILURE_RATE_THRESHOLD, (Object)(config.getFailureRateThreshold() + "%")).withDetail(MAX_BUFFERED_CALLS, (Object)metrics.getMaxNumberOfBufferedCalls()).withDetail(BUFFERED_CALLS, (Object)metrics.getNumberOfBufferedCalls()).withDetail(FAILED_CALLS, (Object)metrics.getNumberOfFailedCalls()).withDetail(NOT_PERMITTED, (Object)metrics.getNumberOfNotPermittedCalls()).withDetail(STATE, (Object)circuitBreaker.getState());
        return builder;
    }
}

