/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.monitoring.health;

import io.github.resilience4j.common.ratelimiter.configuration.RateLimiterConfigurationProperties;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.ratelimiter.configure.RateLimiterConfigurationProperties;
import io.github.resilience4j.ratelimiter.internal.AtomicRateLimiter;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.Status;

public class RateLimitersHealthIndicator
implements HealthIndicator {
    private final RateLimiterRegistry rateLimiterRegistry;
    private final RateLimiterConfigurationProperties rateLimiterProperties;
    private final HealthAggregator healthAggregator;

    public RateLimitersHealthIndicator(RateLimiterRegistry rateLimiterRegistry, RateLimiterConfigurationProperties rateLimiterProperties, HealthAggregator healthAggregator) {
        this.rateLimiterRegistry = rateLimiterRegistry;
        this.rateLimiterProperties = rateLimiterProperties;
        this.healthAggregator = healthAggregator;
    }

    public Health health() {
        Map<String, Health> healths = this.rateLimiterRegistry.getAllRateLimiters().toJavaStream().filter(this::isRegisterHealthIndicator).collect(Collectors.toMap(RateLimiter::getName, this::mapRateLimiterHealth));
        return this.healthAggregator.aggregate(healths);
    }

    private boolean isRegisterHealthIndicator(RateLimiter rateLimiter) {
        return this.rateLimiterProperties.findRateLimiterProperties(rateLimiter.getName()).map(RateLimiterConfigurationProperties.InstanceProperties::getRegisterHealthIndicator).orElse(false);
    }

    private Health mapRateLimiterHealth(RateLimiter rateLimiter) {
        AtomicRateLimiter atomicRateLimiter;
        AtomicRateLimiter.AtomicRateLimiterMetrics detailedMetrics;
        RateLimiter.Metrics metrics = rateLimiter.getMetrics();
        int availablePermissions = metrics.getAvailablePermissions();
        int numberOfWaitingThreads = metrics.getNumberOfWaitingThreads();
        long timeoutInNanos = rateLimiter.getRateLimiterConfig().getTimeoutDuration().toNanos();
        if (availablePermissions > 0 || numberOfWaitingThreads == 0) {
            return RateLimitersHealthIndicator.rateLimiterHealth(Status.UP, availablePermissions, numberOfWaitingThreads);
        }
        if (rateLimiter instanceof AtomicRateLimiter && (detailedMetrics = (atomicRateLimiter = (AtomicRateLimiter)rateLimiter).getDetailedMetrics()).getNanosToWait() > timeoutInNanos) {
            return RateLimitersHealthIndicator.rateLimiterHealth(Status.DOWN, availablePermissions, numberOfWaitingThreads);
        }
        return RateLimitersHealthIndicator.rateLimiterHealth(Status.UNKNOWN, availablePermissions, numberOfWaitingThreads);
    }

    private static Health rateLimiterHealth(Status status, int availablePermissions, int numberOfWaitingThreads) {
        return Health.status((Status)status).withDetail("availablePermissions", (Object)availablePermissions).withDetail("numberOfWaitingThreads", (Object)numberOfWaitingThreads).build();
    }
}

