/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.autoconfigure;

import com.codahale.metrics.MetricRegistry;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.circuitbreaker.autoconfigure.CircuitBreakerAutoConfiguration;
import io.github.resilience4j.metrics.CircuitBreakerMetrics;
import org.springframework.boot.actuate.autoconfigure.MetricRepositoryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.MetricsDropwizardAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MetricRegistry.class})
@AutoConfigureAfter(value={CircuitBreakerAutoConfiguration.class, MetricsDropwizardAutoConfiguration.class})
@AutoConfigureBefore(value={MetricRepositoryAutoConfiguration.class})
@ConditionalOnProperty(value={"resilience4j.circuitbreaker.metrics.enabled"}, matchIfMissing=true)
public class CircuitBreakerMetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public CircuitBreakerMetrics registerCircuitBreakerMetrics(CircuitBreakerRegistry circuitBreakerRegistry, MetricRegistry metricRegistry) {
        return CircuitBreakerMetrics.ofCircuitBreakerRegistry((CircuitBreakerRegistry)circuitBreakerRegistry, (MetricRegistry)metricRegistry);
    }
}

