/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.autoconfigure;

import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.circuitbreaker.autoconfigure.CircuitBreakerAutoConfiguration;
import io.github.resilience4j.prometheus.collectors.CircuitBreakerMetricsCollector;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={CircuitBreakerAutoConfiguration.class})
@ConditionalOnClass(value={CircuitBreakerMetricsCollector.class})
@ConditionalOnProperty(value={"resilience4j.circuitbreaker.metrics.enabled"}, matchIfMissing=true)
public class CircuitBreakerPrometheusAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public CircuitBreakerMetricsCollector circuitBreakerPrometheusCollector(CircuitBreakerRegistry circuitBreakerRegistry) {
        CircuitBreakerMetricsCollector collector = CircuitBreakerMetricsCollector.ofCircuitBreakerRegistry((CircuitBreakerRegistry)circuitBreakerRegistry);
        collector.register();
        return collector;
    }
}

