/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.monitoring.endpoint;

import io.github.resilience4j.circuitbreaker.event.CircuitBreakerEvent;
import io.github.resilience4j.common.circuitbreaker.monitoring.endpoint.CircuitBreakerEventDTOFactory;
import io.github.resilience4j.common.circuitbreaker.monitoring.endpoint.CircuitBreakerEventsEndpointResponse;
import io.github.resilience4j.consumer.CircularEventConsumer;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.vavr.collection.List;
import java.util.Comparator;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"circuitbreaker/"})
public class CircuitBreakerEventsEndpoint {
    private final EventConsumerRegistry<CircuitBreakerEvent> eventConsumerRegistry;

    public CircuitBreakerEventsEndpoint(EventConsumerRegistry<CircuitBreakerEvent> eventConsumerRegistry) {
        this.eventConsumerRegistry = eventConsumerRegistry;
    }

    @GetMapping(value={"events"}, produces={"application/json"})
    @ResponseBody
    public CircuitBreakerEventsEndpointResponse getAllCircuitBreakerEvents() {
        return new CircuitBreakerEventsEndpointResponse(this.eventConsumerRegistry.getAllEventConsumer().flatMap(CircularEventConsumer::getBufferedEvents).sorted(Comparator.comparing(CircuitBreakerEvent::getCreationTime)).map(CircuitBreakerEventDTOFactory::createCircuitBreakerEventDTO).toJavaList());
    }

    @GetMapping(value={"events/{circuitBreakerName}"}, produces={"application/json"})
    @ResponseBody
    public CircuitBreakerEventsEndpointResponse getEventsFilteredByCircuitBreakerName(@PathVariable(value="circuitBreakerName") String circuitBreakerName) {
        return new CircuitBreakerEventsEndpointResponse(this.getCircuitBreakerEvents(circuitBreakerName).filter(event -> event.getCircuitBreakerName().equals(circuitBreakerName)).map(CircuitBreakerEventDTOFactory::createCircuitBreakerEventDTO).toJavaList());
    }

    @GetMapping(value={"events/{circuitBreakerName}/{eventType}"}, produces={"application/json"})
    @ResponseBody
    public CircuitBreakerEventsEndpointResponse getEventsFilteredByCircuitBreakerNameAndEventType(@PathVariable(value="circuitBreakerName") String circuitBreakerName, @PathVariable(value="eventType") String eventType) {
        return new CircuitBreakerEventsEndpointResponse(this.getCircuitBreakerEvents(circuitBreakerName).filter(event -> event.getEventType() == CircuitBreakerEvent.Type.valueOf((String)eventType.toUpperCase())).map(CircuitBreakerEventDTOFactory::createCircuitBreakerEventDTO).toJavaList());
    }

    private List<CircuitBreakerEvent> getCircuitBreakerEvents(String circuitBreakerName) {
        CircularEventConsumer eventConsumer = this.eventConsumerRegistry.getEventConsumer(circuitBreakerName);
        if (eventConsumer != null) {
            return eventConsumer.getBufferedEvents().filter(event -> event.getCircuitBreakerName().equals(circuitBreakerName));
        }
        return List.empty();
    }
}

