/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.autoconfigure;

import io.github.resilience4j.prometheus.collectors.RateLimiterMetricsCollector;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.ratelimiter.autoconfigure.RateLimiterAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={RateLimiterAutoConfiguration.class})
@ConditionalOnClass(value={RateLimiterMetricsCollector.class})
@ConditionalOnProperty(value={"resilience4j.ratelimiter.metrics.enabled"}, matchIfMissing=true)
public class RateLimiterPrometheusAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public RateLimiterMetricsCollector rateLimiterPrometheusCollector(RateLimiterRegistry rateLimiterRegistry) {
        RateLimiterMetricsCollector collector = RateLimiterMetricsCollector.ofRateLimiterRegistry((RateLimiterRegistry)rateLimiterRegistry);
        collector.register();
        return collector;
    }
}

