/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.monitoring.endpoint;

import io.github.resilience4j.common.ratelimiter.monitoring.endpoint.RateLimiterEventDTO;
import io.github.resilience4j.common.ratelimiter.monitoring.endpoint.RateLimiterEventsEndpointResponse;
import io.github.resilience4j.consumer.CircularEventConsumer;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.ratelimiter.event.RateLimiterEvent;
import java.util.Comparator;
import java.util.List;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"ratelimiter/"})
public class RateLimiterEventsEndpoint {
    private final EventConsumerRegistry<RateLimiterEvent> eventsConsumerRegistry;

    public RateLimiterEventsEndpoint(EventConsumerRegistry<RateLimiterEvent> eventsConsumerRegistry) {
        this.eventsConsumerRegistry = eventsConsumerRegistry;
    }

    @GetMapping(value={"events"}, produces={"application/json"})
    @ResponseBody
    public RateLimiterEventsEndpointResponse getAllRateLimiterEvents() {
        List eventsList = this.eventsConsumerRegistry.getAllEventConsumer().flatMap(CircularEventConsumer::getBufferedEvents).sorted(Comparator.comparing(RateLimiterEvent::getCreationTime)).map(RateLimiterEventDTO::createRateLimiterEventDTO).toJavaList();
        return new RateLimiterEventsEndpointResponse(eventsList);
    }

    @GetMapping(value={"events/{rateLimiterName}"}, produces={"application/json"})
    @ResponseBody
    public RateLimiterEventsEndpointResponse getEventsFilteredByRateLimiterName(@PathVariable(value="rateLimiterName") String rateLimiterName) {
        List eventsList = this.eventsConsumerRegistry.getEventConsumer(rateLimiterName).getBufferedEvents().filter(event -> event.getRateLimiterName().equals(rateLimiterName)).map(RateLimiterEventDTO::createRateLimiterEventDTO).toJavaList();
        return new RateLimiterEventsEndpointResponse(eventsList);
    }

    @GetMapping(value={"events/{rateLimiterName}/{eventType}"}, produces={"application/json"})
    @ResponseBody
    public RateLimiterEventsEndpointResponse getEventsFilteredByRateLimiterNameAndEventType(@PathVariable(value="rateLimiterName") String rateLimiterName, @PathVariable(value="eventType") String eventType) {
        RateLimiterEvent.Type targetType = RateLimiterEvent.Type.valueOf((String)eventType.toUpperCase());
        List eventsList = this.eventsConsumerRegistry.getEventConsumer(rateLimiterName).getBufferedEvents().filter(event -> event.getRateLimiterName().equals(rateLimiterName)).filter(event -> event.getEventType() == targetType).map(RateLimiterEventDTO::createRateLimiterEventDTO).toJavaList();
        return new RateLimiterEventsEndpointResponse(eventsList);
    }
}

