/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.autoconfigure;

import com.codahale.metrics.MetricRegistry;
import io.github.resilience4j.metrics.RetryMetrics;
import io.github.resilience4j.retry.RetryRegistry;
import io.github.resilience4j.retry.autoconfigure.RetryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.MetricRepositoryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.MetricsDropwizardAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MetricRegistry.class})
@AutoConfigureAfter(value={RetryAutoConfiguration.class, MetricsDropwizardAutoConfiguration.class})
@AutoConfigureBefore(value={MetricRepositoryAutoConfiguration.class})
@ConditionalOnProperty(value={"resilience4j.retry.metrics.enabled"}, matchIfMissing=true)
public class RetryMetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public RetryMetrics registerRetryMetrics(RetryRegistry retryRegistry, MetricRegistry metricRegistry) {
        return RetryMetrics.ofRetryRegistry((RetryRegistry)retryRegistry, (MetricRegistry)metricRegistry);
    }
}

