/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.autoconfigure;

import io.github.resilience4j.micrometer.tagged.TaggedRetryMetrics;
import io.github.resilience4j.retry.RetryRegistry;
import io.github.resilience4j.retry.autoconfigure.RetryAutoConfiguration;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MetricsAutoConfiguration.class})
@AutoConfigureAfter(value={RetryAutoConfiguration.class, MetricsAutoConfiguration.class})
@ConditionalOnProperty(value={"resilience4j.retry.metrics.enabled"}, matchIfMissing=true)
public class RetryMicrometerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public TaggedRetryMetrics registerRetryMetrics(RetryRegistry retryRegistry) {
        return TaggedRetryMetrics.ofRetryRegistry((RetryRegistry)retryRegistry);
    }
}

