/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.autoconfigure;

import com.codahale.metrics.MetricRegistry;
import io.github.resilience4j.metrics.RateLimiterMetrics;
import io.github.resilience4j.metrics.publisher.RateLimiterMetricsPublisher;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import org.springframework.boot.actuate.autoconfigure.MetricRepositoryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.MetricsDropwizardAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MetricRegistry.class, RateLimiter.class, RateLimiterMetricsPublisher.class})
@AutoConfigureAfter(value={MetricsDropwizardAutoConfiguration.class})
@AutoConfigureBefore(value={MetricRepositoryAutoConfiguration.class})
@ConditionalOnProperty(value={"resilience4j.ratelimiter.metrics.enabled"}, matchIfMissing=true)
public class RateLimiterMetricsAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"resilience4j.ratelimiter.metrics.legacy.enabled"}, havingValue="true")
    @ConditionalOnMissingBean
    public RateLimiterMetrics registerRateLimiterMetrics(RateLimiterRegistry rateLimiterRegistry, MetricRegistry metricRegistry) {
        return RateLimiterMetrics.ofRateLimiterRegistry((RateLimiterRegistry)rateLimiterRegistry, (MetricRegistry)metricRegistry);
    }

    @Bean
    @ConditionalOnProperty(value={"resilience4j.ratelimiter.metrics.legacy.enabled"}, havingValue="false", matchIfMissing=true)
    @ConditionalOnMissingBean
    public RateLimiterMetricsPublisher rateLimiterMetricsPublisher(MetricRegistry metricRegistry) {
        return new RateLimiterMetricsPublisher(metricRegistry);
    }
}

