/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.autoconfigure;

import io.github.resilience4j.micrometer.tagged.TaggedRetryMetrics;
import io.github.resilience4j.micrometer.tagged.TaggedRetryMetricsPublisher;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MetricsAutoConfiguration.class, Retry.class, TaggedRetryMetricsPublisher.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnProperty(value={"resilience4j.retry.metrics.enabled"}, matchIfMissing=true)
public class RetryMicrometerAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"resilience4j.retry.metrics.legacy.enabled"}, havingValue="true")
    @ConditionalOnMissingBean
    public TaggedRetryMetrics registerRetryMetrics(RetryRegistry retryRegistry) {
        return TaggedRetryMetrics.ofRetryRegistry((RetryRegistry)retryRegistry);
    }

    @Bean
    @ConditionalOnBean(value={MeterRegistry.class})
    @ConditionalOnProperty(value={"resilience4j.retry.metrics.legacy.enabled"}, havingValue="false", matchIfMissing=true)
    @ConditionalOnMissingBean
    public TaggedRetryMetricsPublisher taggedRetryMetricsPublisher(MeterRegistry meterRegistry) {
        return new TaggedRetryMetricsPublisher(meterRegistry);
    }
}

