/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.timelimiter.autoconfigure;

import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import io.github.resilience4j.timelimiter.autoconfigure.TimeLimiterConfigurationOnMissingBean;
import io.github.resilience4j.timelimiter.autoconfigure.TimeLimiterProperties;
import io.github.resilience4j.timelimiter.event.TimeLimiterEvent;
import io.github.resilience4j.timelimiter.monitoring.endpoint.TimeLimiterEndpoint;
import io.github.resilience4j.timelimiter.monitoring.endpoint.TimeLimiterEventsEndpoint;
import org.springframework.boot.actuate.autoconfigure.EndpointAutoConfiguration;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={TimeLimiter.class})
@EnableConfigurationProperties(value={TimeLimiterProperties.class})
@Import(value={TimeLimiterConfigurationOnMissingBean.class})
@AutoConfigureBefore(value={EndpointAutoConfiguration.class})
public class TimeLimiterAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={Endpoint.class})
    public static class TimeLimiterEndpointConfiguration {
        @Bean
        public TimeLimiterEndpoint timeLimiterEndpoint(TimeLimiterRegistry timeLimiterRegistry) {
            return new TimeLimiterEndpoint(timeLimiterRegistry);
        }

        @Bean
        public TimeLimiterEventsEndpoint timeLimiterEventsEndpoint(EventConsumerRegistry<TimeLimiterEvent> eventsConsumerRegistry) {
            return new TimeLimiterEventsEndpoint(eventsConsumerRegistry);
        }
    }
}

