/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.timelimiter.autoconfigure;

import io.github.resilience4j.micrometer.tagged.TaggedTimeLimiterMetrics;
import io.github.resilience4j.micrometer.tagged.TaggedTimeLimiterMetricsPublisher;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MetricsAutoConfiguration.class, TimeLimiter.class, TaggedTimeLimiterMetricsPublisher.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnProperty(value={"resilience4j.timelimiter.metrics.enabled"}, matchIfMissing=true)
public class TimeLimiterMicrometerAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"resilience4j.timelimiter.metrics.legacy.enabled"}, havingValue="true")
    @ConditionalOnMissingBean
    public TaggedTimeLimiterMetrics registerTimeLimiterMetrics(TimeLimiterRegistry timeLimiterRegistry) {
        return TaggedTimeLimiterMetrics.ofTimeLimiterRegistry((TimeLimiterRegistry)timeLimiterRegistry);
    }

    @Bean
    @ConditionalOnBean(value={MeterRegistry.class})
    @ConditionalOnProperty(value={"resilience4j.timelimiter.metrics.legacy.enabled"}, havingValue="false", matchIfMissing=true)
    @ConditionalOnMissingBean
    public TaggedTimeLimiterMetricsPublisher taggedTimeLimiterMetricsPublisher(MeterRegistry meterRegistry) {
        return new TaggedTimeLimiterMetricsPublisher(meterRegistry);
    }
}

