/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.monitoring.endpoint;

import io.github.resilience4j.circuitbreaker.event.CircuitBreakerEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnCallNotPermittedEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnErrorEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnIgnoredErrorEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnResetEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnStateTransitionEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnSuccessEvent;
import io.github.resilience4j.circuitbreaker.monitoring.endpoint.CircuitBreakerEventDTO;
import io.github.resilience4j.circuitbreaker.monitoring.endpoint.CircuitBreakerEventDTOBuilder;

class CircuitBreakerEventDTOFactory {
    CircuitBreakerEventDTOFactory() {
    }

    static CircuitBreakerEventDTO createCircuitBreakerEventDTO(CircuitBreakerEvent event) {
        switch (event.getEventType()) {
            case ERROR: {
                CircuitBreakerOnErrorEvent onErrorEvent = (CircuitBreakerOnErrorEvent)event;
                return CircuitBreakerEventDTOFactory.newCircuitBreakerEventDTOBuilder((CircuitBreakerEvent)onErrorEvent).setThrowable(onErrorEvent.getThrowable()).setDuration(onErrorEvent.getElapsedDuration()).build();
            }
            case SUCCESS: {
                CircuitBreakerOnSuccessEvent onSuccessEvent = (CircuitBreakerOnSuccessEvent)event;
                return CircuitBreakerEventDTOFactory.newCircuitBreakerEventDTOBuilder((CircuitBreakerEvent)onSuccessEvent).setDuration(onSuccessEvent.getElapsedDuration()).build();
            }
            case STATE_TRANSITION: {
                CircuitBreakerOnStateTransitionEvent onStateTransitionEvent = (CircuitBreakerOnStateTransitionEvent)event;
                return CircuitBreakerEventDTOFactory.newCircuitBreakerEventDTOBuilder((CircuitBreakerEvent)onStateTransitionEvent).setStateTransition(onStateTransitionEvent.getStateTransition()).build();
            }
            case RESET: {
                CircuitBreakerOnResetEvent onResetEvent = (CircuitBreakerOnResetEvent)event;
                return CircuitBreakerEventDTOFactory.newCircuitBreakerEventDTOBuilder((CircuitBreakerEvent)onResetEvent).build();
            }
            case IGNORED_ERROR: {
                CircuitBreakerOnIgnoredErrorEvent onIgnoredErrorEvent = (CircuitBreakerOnIgnoredErrorEvent)event;
                return CircuitBreakerEventDTOFactory.newCircuitBreakerEventDTOBuilder((CircuitBreakerEvent)onIgnoredErrorEvent).setThrowable(onIgnoredErrorEvent.getThrowable()).build();
            }
            case NOT_PERMITTED: {
                CircuitBreakerOnCallNotPermittedEvent onCallNotPermittedEvent = (CircuitBreakerOnCallNotPermittedEvent)event;
                return CircuitBreakerEventDTOFactory.newCircuitBreakerEventDTOBuilder((CircuitBreakerEvent)onCallNotPermittedEvent).build();
            }
        }
        throw new IllegalArgumentException("Invalid event");
    }

    private static CircuitBreakerEventDTOBuilder newCircuitBreakerEventDTOBuilder(CircuitBreakerEvent event) {
        return new CircuitBreakerEventDTOBuilder(event.getCircuitBreakerName(), event.getEventType(), event.getCreationTime().toString());
    }
}

