/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.monitoring.endpoint;

import io.github.resilience4j.common.retry.monitoring.endpoint.RetryEventDTOFactory;
import io.github.resilience4j.common.retry.monitoring.endpoint.RetryEventsEndpointResponse;
import io.github.resilience4j.consumer.CircularEventConsumer;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.retry.event.RetryEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="retryevents")
public class RetryEventsEndpoint {
    private final EventConsumerRegistry<RetryEvent> eventConsumerRegistry;

    public RetryEventsEndpoint(EventConsumerRegistry<RetryEvent> eventConsumerRegistry) {
        this.eventConsumerRegistry = eventConsumerRegistry;
    }

    @ReadOperation
    public RetryEventsEndpointResponse getAllRetryEvents() {
        return new RetryEventsEndpointResponse(this.eventConsumerRegistry.getAllEventConsumer().stream().flatMap(CircularEventConsumer::getBufferedEventsStream).sorted(Comparator.comparing(RetryEvent::getCreationTime)).map(RetryEventDTOFactory::createRetryEventDTO).collect(Collectors.toList()));
    }

    @ReadOperation
    public RetryEventsEndpointResponse getEventsFilteredByRetryName(@Selector String name) {
        return new RetryEventsEndpointResponse(this.getRetryEvents(name).stream().map(RetryEventDTOFactory::createRetryEventDTO).collect(Collectors.toList()));
    }

    @ReadOperation
    public RetryEventsEndpointResponse getEventsFilteredByRetryNameAndEventType(@Selector String name, @Selector String eventType) {
        return new RetryEventsEndpointResponse(this.getRetryEvents(name).stream().filter(event -> event.getEventType() == RetryEvent.Type.valueOf((String)eventType.toUpperCase())).map(RetryEventDTOFactory::createRetryEventDTO).collect(Collectors.toList()));
    }

    private List<RetryEvent> getRetryEvents(String name) {
        CircularEventConsumer syncEvents = this.eventConsumerRegistry.getEventConsumer(name);
        if (syncEvents != null) {
            return syncEvents.getBufferedEventsStream().filter(event -> event.getName().equals(name)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

