/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.configure;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.circuitbreaker.configure.CircuitBreakerAspectExt;
import io.github.resilience4j.circuitbreaker.configure.CircuitBreakerConfigurationProperties;
import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.fallback.FallbackDecorators;
import io.github.resilience4j.fallback.FallbackMethod;
import io.github.resilience4j.utils.AnnotationExtractor;
import io.vavr.CheckedFunction0;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;

@Aspect
public class CircuitBreakerAspect
implements Ordered {
    private static final Logger logger = LoggerFactory.getLogger(CircuitBreakerAspect.class);
    private final CircuitBreakerConfigurationProperties circuitBreakerProperties;
    private final CircuitBreakerRegistry circuitBreakerRegistry;
    @Nullable
    private final List<CircuitBreakerAspectExt> circuitBreakerAspectExtList;
    private final FallbackDecorators fallbackDecorators;

    public CircuitBreakerAspect(CircuitBreakerConfigurationProperties circuitBreakerProperties, CircuitBreakerRegistry circuitBreakerRegistry, @Autowired(required=false) List<CircuitBreakerAspectExt> circuitBreakerAspectExtList, FallbackDecorators fallbackDecorators) {
        this.circuitBreakerProperties = circuitBreakerProperties;
        this.circuitBreakerRegistry = circuitBreakerRegistry;
        this.circuitBreakerAspectExtList = circuitBreakerAspectExtList;
        this.fallbackDecorators = fallbackDecorators;
    }

    @Pointcut(value="@within(circuitBreaker) || @annotation(circuitBreaker)", argNames="circuitBreaker")
    public void matchAnnotatedClassOrMethod(io.github.resilience4j.circuitbreaker.annotation.CircuitBreaker circuitBreaker) {
    }

    @Around(value="matchAnnotatedClassOrMethod(circuitBreakerAnnotation)", argNames="proceedingJoinPoint, circuitBreakerAnnotation")
    public Object circuitBreakerAroundAdvice(ProceedingJoinPoint proceedingJoinPoint, @Nullable io.github.resilience4j.circuitbreaker.annotation.CircuitBreaker circuitBreakerAnnotation) throws Throwable {
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        String methodName = method.getDeclaringClass().getName() + "#" + method.getName();
        if (circuitBreakerAnnotation == null) {
            circuitBreakerAnnotation = this.getCircuitBreakerAnnotation(proceedingJoinPoint);
        }
        if (circuitBreakerAnnotation == null) {
            return proceedingJoinPoint.proceed();
        }
        String backend = circuitBreakerAnnotation.name();
        CircuitBreaker circuitBreaker = this.getOrCreateCircuitBreaker(methodName, backend);
        Class<?> returnType = method.getReturnType();
        if (StringUtils.isEmpty((Object)circuitBreakerAnnotation.fallbackMethod())) {
            return this.proceed(proceedingJoinPoint, methodName, circuitBreaker, returnType);
        }
        FallbackMethod fallbackMethod = FallbackMethod.create(circuitBreakerAnnotation.fallbackMethod(), method, proceedingJoinPoint.getArgs(), proceedingJoinPoint.getTarget());
        return this.fallbackDecorators.decorate(fallbackMethod, (CheckedFunction0<Object>)(CheckedFunction0 & Serializable)() -> this.proceed(proceedingJoinPoint, methodName, circuitBreaker, returnType)).apply();
    }

    private Object proceed(ProceedingJoinPoint proceedingJoinPoint, String methodName, CircuitBreaker circuitBreaker, Class<?> returnType) throws Throwable {
        if (this.circuitBreakerAspectExtList != null && !this.circuitBreakerAspectExtList.isEmpty()) {
            for (CircuitBreakerAspectExt circuitBreakerAspectExt : this.circuitBreakerAspectExtList) {
                if (!circuitBreakerAspectExt.canHandleReturnType(returnType)) continue;
                return circuitBreakerAspectExt.handle(proceedingJoinPoint, circuitBreaker, methodName);
            }
        }
        if (CompletionStage.class.isAssignableFrom(returnType)) {
            return this.handleJoinPointCompletableFuture(proceedingJoinPoint, circuitBreaker);
        }
        return this.defaultHandling(proceedingJoinPoint, circuitBreaker);
    }

    private CircuitBreaker getOrCreateCircuitBreaker(String methodName, String backend) {
        CircuitBreaker circuitBreaker = this.circuitBreakerRegistry.circuitBreaker(backend);
        if (logger.isDebugEnabled()) {
            logger.debug("Created or retrieved circuit breaker '{}' with failure rate '{}' and wait interval '{}' for method: '{}'", new Object[]{backend, Float.valueOf(circuitBreaker.getCircuitBreakerConfig().getFailureRateThreshold()), circuitBreaker.getCircuitBreakerConfig().getWaitDurationInOpenState(), methodName});
        }
        return circuitBreaker;
    }

    @Nullable
    private io.github.resilience4j.circuitbreaker.annotation.CircuitBreaker getCircuitBreakerAnnotation(ProceedingJoinPoint proceedingJoinPoint) {
        if (logger.isDebugEnabled()) {
            logger.debug("circuitBreaker parameter is null");
        }
        if (proceedingJoinPoint.getTarget() instanceof Proxy) {
            logger.debug("The circuit breaker annotation is kept on a interface which is acting as a proxy");
            return AnnotationExtractor.extractAnnotationFromProxy(proceedingJoinPoint.getTarget(), io.github.resilience4j.circuitbreaker.annotation.CircuitBreaker.class);
        }
        return AnnotationExtractor.extract(proceedingJoinPoint.getTarget().getClass(), io.github.resilience4j.circuitbreaker.annotation.CircuitBreaker.class);
    }

    private Object handleJoinPointCompletableFuture(ProceedingJoinPoint proceedingJoinPoint, CircuitBreaker circuitBreaker) {
        return circuitBreaker.executeCompletionStage(() -> {
            try {
                return (CompletionStage)proceedingJoinPoint.proceed();
            }
            catch (Throwable throwable) {
                throw new CompletionException(throwable);
            }
        });
    }

    private Object defaultHandling(ProceedingJoinPoint proceedingJoinPoint, CircuitBreaker circuitBreaker) throws Throwable {
        return circuitBreaker.executeCheckedSupplier(() -> ((ProceedingJoinPoint)proceedingJoinPoint).proceed());
    }

    public int getOrder() {
        return this.circuitBreakerProperties.getCircuitBreakerAspectOrder();
    }
}

