/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.configure;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.configure.CircuitBreakerAspectExt;
import io.github.resilience4j.circuitbreaker.operator.CircuitBreakerOperator;
import io.github.resilience4j.utils.AspectUtil;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.CompletableTransformer;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.MaybeTransformer;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.SingleTransformer;
import java.util.Set;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RxJava2CircuitBreakerAspectExt
implements CircuitBreakerAspectExt {
    private static final Logger logger = LoggerFactory.getLogger(RxJava2CircuitBreakerAspectExt.class);
    private final Set<Class> rxSupportedTypes = AspectUtil.newHashSet(ObservableSource.class, SingleSource.class, CompletableSource.class, MaybeSource.class, Flowable.class);

    @Override
    public boolean canHandleReturnType(Class returnType) {
        return this.rxSupportedTypes.stream().anyMatch(classType -> classType.isAssignableFrom(returnType));
    }

    @Override
    public Object handle(ProceedingJoinPoint proceedingJoinPoint, CircuitBreaker circuitBreaker, String methodName) throws Throwable {
        CircuitBreakerOperator circuitBreakerOperator = CircuitBreakerOperator.of((CircuitBreaker)circuitBreaker);
        Object returnValue = proceedingJoinPoint.proceed();
        return this.executeRxJava2Aspect(circuitBreakerOperator, returnValue, methodName);
    }

    private Object executeRxJava2Aspect(CircuitBreakerOperator circuitBreakerOperator, Object returnValue, String methodName) {
        if (returnValue instanceof ObservableSource) {
            Observable observable = (Observable)returnValue;
            return observable.compose((ObservableTransformer)circuitBreakerOperator);
        }
        if (returnValue instanceof SingleSource) {
            Single single = (Single)returnValue;
            return single.compose((SingleTransformer)circuitBreakerOperator);
        }
        if (returnValue instanceof CompletableSource) {
            Completable completable = (Completable)returnValue;
            return completable.compose((CompletableTransformer)circuitBreakerOperator);
        }
        if (returnValue instanceof MaybeSource) {
            Maybe maybe = (Maybe)returnValue;
            return maybe.compose((MaybeTransformer)circuitBreakerOperator);
        }
        if (returnValue instanceof Flowable) {
            Flowable flowable = (Flowable)returnValue;
            return flowable.compose((FlowableTransformer)circuitBreakerOperator);
        }
        logger.error("Unsupported type for RxJava2 circuit breaker return type {} for method {}", (Object)returnValue.getClass().getTypeName(), (Object)methodName);
        throw new IllegalArgumentException("Not Supported type for the circuit breaker in RxJava2:" + returnValue.getClass().getName());
    }
}

