/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.vertx.core.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public interface VertxCircuitBreaker {
    public static <T> Future<T> executeFuture(CircuitBreaker circuitBreaker, Supplier<Future<T>> supplier) {
        return VertxCircuitBreaker.decorateFuture(circuitBreaker, supplier).get();
    }

    public static <T> Supplier<Future<T>> decorateFuture(CircuitBreaker circuitBreaker, Supplier<Future<T>> supplier) {
        return () -> {
            Future future = Future.future();
            if (!circuitBreaker.tryAcquirePermission()) {
                future.fail((Throwable)CallNotPermittedException.createCallNotPermittedException((CircuitBreaker)circuitBreaker));
            } else {
                long start = System.nanoTime();
                try {
                    ((Future)supplier.get()).setHandler(result -> {
                        long durationInNanos = System.nanoTime() - start;
                        if (result.failed()) {
                            circuitBreaker.onError(durationInNanos, TimeUnit.NANOSECONDS, result.cause());
                            future.fail(result.cause());
                        } else {
                            circuitBreaker.onSuccess(durationInNanos, TimeUnit.NANOSECONDS);
                            future.complete(result.result());
                        }
                    });
                }
                catch (Exception exception) {
                    long durationInNanos = System.nanoTime() - start;
                    circuitBreaker.onError(durationInNanos, TimeUnit.NANOSECONDS, (Throwable)exception);
                    future.fail((Throwable)exception);
                }
            }
            return future;
        };
    }
}

