/*
 * Decompiled with CFR 0.152.
 */
package io.github.rhwayfun.springboot.rocketmq.starter.common;

import java.util.Objects;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRocketMqProducer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private DefaultMQProducer producer;

    public boolean sendMsg(Message msg) {
        SendResult sendResult = null;
        try {
            sendResult = this.producer.send(msg);
        }
        catch (Exception e) {
            this.logger.error("send msg error", (Throwable)e);
        }
        return sendResult != null && sendResult.getSendStatus() == SendStatus.SEND_OK;
    }

    public void sendOneWayMsg(Message msg) {
        try {
            this.producer.sendOneway(msg);
        }
        catch (Exception e) {
            this.logger.error("send msg error", (Throwable)e);
        }
    }

    public boolean sendDelayMsg(String topic, String tag, Message msg, int delayLevel) {
        msg.setDelayTimeLevel(delayLevel);
        SendResult sendResult = null;
        try {
            sendResult = this.producer.send(msg);
        }
        catch (Exception e) {
            this.logger.error("send msg error", (Throwable)e);
        }
        return sendResult != null && sendResult.getSendStatus() == SendStatus.SEND_OK;
    }

    public DefaultMQProducer getProducer() {
        return this.producer;
    }

    public void setProducer(DefaultMQProducer producer) {
        this.producer = producer;
    }

    public void destroy() {
        if (Objects.nonNull(this.producer)) {
            this.producer.shutdown();
        }
    }
}

