/*
 * Decompiled with CFR 0.152.
 */
package io.github.rhwayfun.springboot.rocketmq.starter.config;

import io.github.rhwayfun.springboot.rocketmq.starter.common.AbstractRocketMqConsumer;
import io.github.rhwayfun.springboot.rocketmq.starter.common.DefaultRocketMqProducer;
import io.github.rhwayfun.springboot.rocketmq.starter.common.RocketMqConsumerMBean;
import io.github.rhwayfun.springboot.rocketmq.starter.config.RocketMqProperties;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.util.CollectionUtils;

@Configuration
@ConditionalOnClass(value={DefaultMQPushConsumer.class})
@EnableConfigurationProperties(value={RocketMqProperties.class})
public class RocketMqAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(RocketMqAutoConfiguration.class);
    @Resource
    private RocketMqProperties rocketMqProperties;

    @Bean
    @ConditionalOnClass(value={DefaultMQProducer.class})
    @ConditionalOnMissingBean(value={DefaultMQProducer.class})
    public DefaultMQProducer mqProducer() {
        DefaultMQProducer producer = new DefaultMQProducer();
        producer.setProducerGroup(this.rocketMqProperties.getProducerGroupName());
        producer.setNamesrvAddr(this.rocketMqProperties.getNameServer());
        producer.setSendMsgTimeout(this.rocketMqProperties.getProducerSendMsgTimeout());
        producer.setRetryTimesWhenSendFailed(this.rocketMqProperties.getProducerRetryTimesWhenSendFailed());
        producer.setRetryTimesWhenSendAsyncFailed(this.rocketMqProperties.getProducerRetryTimesWhenSendAsyncFailed());
        producer.setMaxMessageSize(this.rocketMqProperties.getProducerMaxMessageSize());
        producer.setCompressMsgBodyOverHowmuch(this.rocketMqProperties.getProducerCompressMsgBodyOverHowMuch());
        producer.setRetryAnotherBrokerWhenNotStoreOK(this.rocketMqProperties.isProducerRetryAnotherBrokerWhenNotStoreOk());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LOGGER.info("producer shutdown");
            producer.shutdown();
            LOGGER.info("producer has shutdown");
        }));
        try {
            producer.start();
            LOGGER.info("rocketmq producer started, nameserver:{}, group:{}", (Object)this.rocketMqProperties.getNameServer(), (Object)this.rocketMqProperties.getProducerGroupName());
        }
        catch (MQClientException e) {
            LOGGER.error("producer start error, nameserver:{}, group:{}", new Object[]{this.rocketMqProperties.getNameServer(), this.rocketMqProperties.getProducerGroupName(), e});
        }
        return producer;
    }

    @Bean(destroyMethod="destroy")
    @ConditionalOnBean(value={DefaultMQProducer.class})
    @ConditionalOnMissingBean(name={"defaultRocketMqProducer"})
    public DefaultRocketMqProducer defaultRocketMqProducer(@Qualifier(value="mqProducer") DefaultMQProducer mqProducer) {
        DefaultRocketMqProducer defaultRocketMqProducer = new DefaultRocketMqProducer();
        defaultRocketMqProducer.setProducer(mqProducer);
        return defaultRocketMqProducer;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={AbstractRocketMqConsumer.class})
    @Order
    public RocketMqConsumerMBean rocketMqConsumerMBean(List<AbstractRocketMqConsumer> messageListeners) {
        RocketMqConsumerMBean rocketMqConsumerMBean = new RocketMqConsumerMBean();
        messageListeners.forEach(this::registerMQConsumer);
        rocketMqConsumerMBean.setConsumers(messageListeners);
        return rocketMqConsumerMBean;
    }

    private void registerMQConsumer(AbstractRocketMqConsumer rocketMqConsumer) {
        Map<String, Set<String>> subscribeTopicTags = rocketMqConsumer.subscribeTopicTags();
        DefaultMQPushConsumer mqPushConsumer = rocketMqConsumer.getConsumer();
        mqPushConsumer.setNamesrvAddr(this.rocketMqProperties.getNameServer());
        subscribeTopicTags.entrySet().forEach(e -> {
            try {
                String rocketMqTopic = (String)e.getKey();
                Set rocketMqTags = (Set)e.getValue();
                if (CollectionUtils.isEmpty((Collection)rocketMqTags)) {
                    mqPushConsumer.subscribe(rocketMqTopic, "*");
                } else {
                    String tags = StringUtils.join((Iterable)rocketMqTags, (String)" || ");
                    mqPushConsumer.subscribe(rocketMqTopic, tags);
                    LOGGER.info("subscribe, topic:{}, tags:{}", (Object)rocketMqTopic, (Object)tags);
                }
            }
            catch (MQClientException ex) {
                LOGGER.error("consumer subscribe error", (Throwable)ex);
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LOGGER.info("consumer shutdown");
            mqPushConsumer.shutdown();
            LOGGER.info("consumer has shutdown");
        }));
        try {
            mqPushConsumer.start();
            rocketMqConsumer.setStarted(true);
            LOGGER.info("rocketmq consumer started, nameserver:{}, group:{}", (Object)this.rocketMqProperties.getNameServer(), (Object)rocketMqConsumer.getConsumerGroup());
        }
        catch (MQClientException e2) {
            LOGGER.error("consumer start error, nameserver:{}, group:{}", new Object[]{this.rocketMqProperties.getNameServer(), rocketMqConsumer.getConsumerGroup(), e2});
        }
    }
}

