/*
 * Decompiled with CFR 0.152.
 */
package io.github.robertomike.hefesto.actions;

import io.github.robertomike.hefesto.enums.JoinOperator;
import java.util.Locale;

public class Join {
    private final String table;
    private String alias = null;
    private String fieldJoin;
    private String fieldReference;
    private JoinOperator joinOperator = JoinOperator.INNER;

    public String getAcronym() {
        return this.alias != null ? this.alias : this.table.toLowerCase(Locale.ROOT);
    }

    public static Join make(String table) {
        return new Join(table);
    }

    public static Join make(String table, String fieldJoin) {
        return new Join(table, fieldJoin, null);
    }

    public static Join make(String table, JoinOperator operator) {
        return new Join(table, null, null, null, operator);
    }

    public Join(String table, String fieldJoin, String fieldReference) {
        this.table = table;
        this.fieldJoin = fieldJoin;
        this.fieldReference = fieldReference;
    }

    public Join(String table, String fieldJoin, String fieldReference, String alias) {
        this.table = table;
        this.fieldJoin = fieldJoin;
        this.fieldReference = fieldReference;
        this.alias = alias;
    }

    public static Join make(String table, String fieldJoin, JoinOperator operator) {
        return new Join(table, null, fieldJoin, null, operator);
    }

    public static Join make(String table, String fieldJoin, String fieldReference) {
        return new Join(table, fieldJoin, fieldReference);
    }

    public static Join make(String table, String fieldJoin, String fieldReference, JoinOperator operator) {
        return new Join(table, null, fieldJoin, fieldReference, operator);
    }

    public static Join make(String table, String fieldJoin, String fieldReference, String alias, JoinOperator operator) {
        return new Join(table, alias, fieldJoin, fieldReference, operator);
    }

    public String getTable() {
        return this.table;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getFieldJoin() {
        return this.fieldJoin;
    }

    public String getFieldReference() {
        return this.fieldReference;
    }

    public JoinOperator getJoinOperator() {
        return this.joinOperator;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setFieldJoin(String fieldJoin) {
        this.fieldJoin = fieldJoin;
    }

    public void setFieldReference(String fieldReference) {
        this.fieldReference = fieldReference;
    }

    public void setJoinOperator(JoinOperator joinOperator) {
        this.joinOperator = joinOperator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Join)) {
            return false;
        }
        Join other = (Join)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        String this$fieldJoin = this.getFieldJoin();
        String other$fieldJoin = other.getFieldJoin();
        if (this$fieldJoin == null ? other$fieldJoin != null : !this$fieldJoin.equals(other$fieldJoin)) {
            return false;
        }
        String this$fieldReference = this.getFieldReference();
        String other$fieldReference = other.getFieldReference();
        if (this$fieldReference == null ? other$fieldReference != null : !this$fieldReference.equals(other$fieldReference)) {
            return false;
        }
        JoinOperator this$joinOperator = this.getJoinOperator();
        JoinOperator other$joinOperator = other.getJoinOperator();
        return !(this$joinOperator == null ? other$joinOperator != null : !((Object)((Object)this$joinOperator)).equals((Object)other$joinOperator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Join;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $fieldJoin = this.getFieldJoin();
        result = result * 59 + ($fieldJoin == null ? 43 : $fieldJoin.hashCode());
        String $fieldReference = this.getFieldReference();
        result = result * 59 + ($fieldReference == null ? 43 : $fieldReference.hashCode());
        JoinOperator $joinOperator = this.getJoinOperator();
        result = result * 59 + ($joinOperator == null ? 43 : ((Object)((Object)$joinOperator)).hashCode());
        return result;
    }

    public String toString() {
        return "Join(table=" + this.getTable() + ", alias=" + this.getAlias() + ", fieldJoin=" + this.getFieldJoin() + ", fieldReference=" + this.getFieldReference() + ", joinOperator=" + this.getJoinOperator() + ")";
    }

    public Join(String table, String alias, String fieldJoin, String fieldReference, JoinOperator joinOperator) {
        this.table = table;
        this.alias = alias;
        this.fieldJoin = fieldJoin;
        this.fieldReference = fieldReference;
        this.joinOperator = joinOperator;
    }

    public Join(String table) {
        this.table = table;
    }
}

