/*
 * Decompiled with CFR 0.152.
 */
package io.github.robertomike.hefesto.builders;

import io.github.robertomike.hefesto.actions.GroupBy;
import io.github.robertomike.hefesto.actions.Join;
import io.github.robertomike.hefesto.actions.Select;
import io.github.robertomike.hefesto.constructors.Construct;
import io.github.robertomike.hefesto.constructors.ConstructGroupBy;
import io.github.robertomike.hefesto.constructors.ConstructJoin;
import io.github.robertomike.hefesto.constructors.ConstructOrder;
import io.github.robertomike.hefesto.constructors.ConstructSelect;
import io.github.robertomike.hefesto.constructors.ConstructWhere;
import io.github.robertomike.hefesto.enums.JoinOperator;
import io.github.robertomike.hefesto.enums.Operator;
import io.github.robertomike.hefesto.enums.SelectOperator;
import io.github.robertomike.hefesto.exceptions.QueryException;
import io.github.robertomike.hefesto.models.BaseModel;
import io.github.robertomike.hefesto.utils.CastUtils;
import io.github.robertomike.hefesto.utils.ConditionalBuilder;
import io.github.robertomike.hefesto.utils.Page;
import io.github.robertomike.hefesto.utils.SortBuilder;
import java.util.AbstractList;
import java.util.List;
import java.util.Optional;

public abstract class BaseBuilder<Model extends BaseModel, SESSION, WHERE extends ConstructWhere, JOIN extends ConstructJoin, ORDER extends ConstructOrder, SELECT extends ConstructSelect, GROUP extends ConstructGroupBy, BUILDER extends BaseBuilder<Model, SESSION, WHERE, JOIN, ORDER, SELECT, GROUP, BUILDER>>
implements ConditionalBuilder<BUILDER>,
SortBuilder<BUILDER> {
    protected String table;
    protected SELECT selects;
    protected ORDER orders;
    protected GROUP groupBy;
    protected WHERE wheres;
    protected JOIN joins;
    protected Class<Model> model;
    protected Integer offset = null;
    protected Integer limit = null;
    protected static Object session;

    public BaseBuilder(Class<Model> model) {
        this.model = model;
    }

    public SESSION getSession() {
        if (session == null) {
            throw new QueryException("Session is not set");
        }
        return (SESSION)session;
    }

    public BUILDER setSelect(String select) {
        ((AbstractList)this.selects).clear();
        ((Construct)this.selects).add((Select)new Select(select));
        return (BUILDER)this;
    }

    public BUILDER addSelect(String select) {
        ((Construct)this.selects).add((Select)new Select(select));
        return (BUILDER)this;
    }

    public BUILDER setSelects(String ... selects) {
        ((AbstractList)this.selects).clear();
        for (String select : selects) {
            ((Construct)this.selects).add((Select)new Select(select));
        }
        return (BUILDER)this;
    }

    public BUILDER addSelect(Select ... selects) {
        ((Construct)this.selects).addAll((Select[])selects);
        return (BUILDER)this;
    }

    public BUILDER addSelect(String select, String alias) {
        ((Construct)this.selects).add((Select)new Select(select, alias));
        return (BUILDER)this;
    }

    public BUILDER addSelect(String select, SelectOperator operator) {
        ((Construct)this.selects).add((Select)new Select(select, operator));
        return (BUILDER)this;
    }

    public BUILDER addSelect(String select, String alias, SelectOperator operator) {
        ((Construct)this.selects).add((Select)new Select(select, alias, operator));
        return (BUILDER)this;
    }

    public BUILDER join(Join join) {
        ((Construct)this.joins).add((Join)join);
        return (BUILDER)this;
    }

    public BUILDER join(String table, String joinField, String referenceField) {
        ((Construct)this.joins).add((Join)Join.make(table, joinField, referenceField));
        return (BUILDER)this;
    }

    public BUILDER join(Class<BaseModel> clazz, String joinField, String referenceField) {
        String table = this.getTableFromClass(clazz);
        ((Construct)this.joins).add((Join)Join.make(table, joinField, referenceField));
        return (BUILDER)this;
    }

    public String getTableFromClass(Class<BaseModel> clazz) {
        return CastUtils.getClassInstance(clazz).getTable();
    }

    public BUILDER join(String table, String joinField, JoinOperator operator) {
        ((Construct)this.joins).add((Join)Join.make(table, joinField, operator));
        return (BUILDER)this;
    }

    public BUILDER groupBy(String ... fields) {
        for (String field : fields) {
            ((Construct)this.groupBy).add((GroupBy)new GroupBy(field));
        }
        return (BUILDER)this;
    }

    public BUILDER groupBy(GroupBy ... groupBy) {
        ((Construct)this.groupBy).addAll((GroupBy[])groupBy);
        return (BUILDER)this;
    }

    public abstract Long countResults();

    public Page<Model> page(int limit) {
        return this.page(limit, 0L);
    }

    public abstract Page<Model> page(int var1, long var2);

    public abstract List<Model> get();

    public List<Model> get(Select ... selects) {
        this.addSelect(selects);
        return this.get();
    }

    public List<Model> get(String ... selects) {
        this.setSelects(selects);
        return this.get();
    }

    public abstract Optional<Model> findFirst();

    public Optional<Model> findFirstBy(String field, Operator operator, Object value) {
        this.where(field, operator, value);
        return this.findFirst();
    }

    public Optional<Model> findFirstBy(String field, Object value) {
        return this.findFirstBy(field, Operator.EQUAL, value);
    }

    public Optional<Model> findFirstById(Object value) {
        this.where("id", value);
        return this.findFirst();
    }

    public boolean exist() {
        return this.countResults() > 0L;
    }

    public boolean existBy(String field, Operator operator, Object value) {
        this.where(field, operator, value);
        return this.exist();
    }

    public boolean existBy(String field, Object value) {
        this.where(field, value);
        return this.exist();
    }

    public BaseBuilder() {
    }

    public String getTable() {
        return this.table;
    }

    public SELECT getSelects() {
        return this.selects;
    }

    public ORDER getOrders() {
        return this.orders;
    }

    public GROUP getGroupBy() {
        return this.groupBy;
    }

    public WHERE getWheres() {
        return this.wheres;
    }

    public JOIN getJoins() {
        return this.joins;
    }

    public Class<Model> getModel() {
        return this.model;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public static void setSession(Object session) {
        BaseBuilder.session = session;
    }
}

