/*
 * Decompiled with CFR 0.152.
 */
package io.github.robertomike.hefesto.utils;

import io.github.robertomike.hefesto.exceptions.HefestoException;
import io.github.robertomike.hefesto.exceptions.QueryException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class CastUtils {
    public static <T> Object castValue(Class<T> type, Object value) {
        if (type.isInstance(value)) {
            return value;
        }
        if (type.equals(String.class)) {
            return type.toString();
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return Integer.valueOf(value.toString());
        }
        if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            return Integer.valueOf(value.toString());
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return Double.valueOf(value.toString());
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return Short.valueOf(value.toString());
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return Long.valueOf(value.toString());
        }
        if (type.equals(BigDecimal.class)) {
            return BigDecimal.valueOf(Double.parseDouble(value.toString()));
        }
        if (type.equals(BigInteger.class)) {
            return BigInteger.valueOf(Long.parseLong(value.toString()));
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return Boolean.valueOf(value.toString());
        }
        if (type.equals(Character.TYPE)) {
            return Character.valueOf(value.toString().charAt(0));
        }
        throw new QueryException("Unsupported casting type:" + type);
    }

    public static <T> T getClassInstance(Class<T> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new HefestoException("Error creating class instance for " + clazz.getName(), e);
        }
    }

    private CastUtils() {
    }
}

