/*
 * Decompiled with CFR 0.152.
 */
package io.github.robertomike.hefesto.utils;

import io.github.robertomike.hefesto.actions.wheres.BaseWhere;
import io.github.robertomike.hefesto.actions.wheres.CollectionWhere;
import io.github.robertomike.hefesto.actions.wheres.Where;
import io.github.robertomike.hefesto.actions.wheres.WhereExist;
import io.github.robertomike.hefesto.builders.BaseBuilder;
import io.github.robertomike.hefesto.constructors.ConstructWhere;
import io.github.robertomike.hefesto.enums.Operator;
import io.github.robertomike.hefesto.enums.WhereOperator;
import java.util.Arrays;
import java.util.List;

public interface ConditionalBuilder<R extends ConditionalBuilder<R>> {
    public ConstructWhere getWheres();

    default public R whereIsNull(String field) {
        this.getWheres().add(new Where(field, Operator.IS_NULL));
        return (R)this;
    }

    default public R whereIsNotNull(String field) {
        this.getWheres().add(new Where(field, Operator.IS_NOT_NULL));
        return (R)this;
    }

    default public R orWhereIsNull(String field) {
        this.getWheres().add(new Where(field, Operator.IS_NULL, (Object)WhereOperator.OR));
        return (R)this;
    }

    default public R orWhereIsNotNull(String field) {
        this.getWheres().add(new Where(field, Operator.IS_NOT_NULL, (Object)WhereOperator.OR));
        return (R)this;
    }

    default public <T extends BaseWhere> R where(T ... whereList) {
        this.getWheres().add(new CollectionWhere(Arrays.asList(whereList)));
        return (R)this;
    }

    default public <T extends BaseWhere> R orWhere(T ... whereList) {
        this.getWheres().add(new CollectionWhere(Arrays.asList(whereList), WhereOperator.OR));
        return (R)this;
    }

    default public R orWhere(String field, Object value) {
        if (value != null) {
            this.getWheres().add(new Where(field, Operator.EQUAL, value, WhereOperator.OR));
        }
        return (R)this;
    }

    default public R orWhere(String field, Operator operator, Object value) {
        if (value != null) {
            this.getWheres().add(new Where(field, operator, value, WhereOperator.OR));
        }
        return (R)this;
    }

    default public R where(String field, Operator operator, Object value) {
        if (value != null) {
            this.getWheres().add(new Where(field, operator, value));
        }
        return (R)this;
    }

    default public R where(String field, Object value) {
        if (value != null) {
            this.getWheres().add(new Where(field, Operator.EQUAL, value));
        }
        return (R)this;
    }

    default public <T> R whereIn(String field, T ... values) {
        this.getWheres().add(new Where(field, Operator.IN, values));
        return (R)this;
    }

    default public <T> R whereIn(String field, Iterable<T> values) {
        if (values.spliterator().getExactSizeIfKnown() == 0L) {
            return (R)this;
        }
        this.getWheres().add(new Where(field, Operator.IN, values));
        return (R)this;
    }

    default public <T extends BaseBuilder> R whereIn(String field, T subQuery) {
        this.getWheres().add(new Where(field, Operator.IN, subQuery));
        return (R)this;
    }

    default public <T extends BaseBuilder> R whereNotIn(String field, T subQuery) {
        this.getWheres().add(new Where(field, Operator.NOT_IN, subQuery));
        return (R)this;
    }

    default public <T> R orWhereIn(String field, T ... values) {
        this.getWheres().add(new Where(field, Operator.IN, values, WhereOperator.OR));
        return (R)this;
    }

    default public <T> R orWhereIn(String field, Iterable<T> values) {
        if (values.spliterator().getExactSizeIfKnown() == 0L) {
            return (R)this;
        }
        this.getWheres().add(new Where(field, Operator.IN, values, WhereOperator.OR));
        return (R)this;
    }

    default public <T extends BaseBuilder> R orWhereIn(String field, T subQuery) {
        this.getWheres().add(new Where(field, Operator.IN, subQuery, WhereOperator.OR));
        return (R)this;
    }

    default public <T extends BaseBuilder> R orWhereNotIn(String field, T subQuery) {
        this.getWheres().add(new Where(field, Operator.NOT_IN, subQuery, WhereOperator.OR));
        return (R)this;
    }

    default public <T> R whereNotIn(String field, T ... values) {
        this.getWheres().add(new Where(field, Operator.NOT_IN, values));
        return (R)this;
    }

    default public <T> R whereNotIn(String field, Iterable<T> values) {
        if (values.spliterator().getExactSizeIfKnown() == 0L) {
            return (R)this;
        }
        this.getWheres().add(new Where(field, Operator.NOT_IN, values));
        return (R)this;
    }

    default public R where(List<? extends BaseWhere> whereList) {
        this.getWheres().add(new CollectionWhere(whereList));
        return (R)this;
    }

    default public <T extends BaseWhere> R where(T where) {
        this.getWheres().add(where);
        return (R)this;
    }

    default public <T extends BaseBuilder> R whereExists(T subQuery) {
        this.getWheres().add(new WhereExist(subQuery));
        return (R)this;
    }

    default public <T extends BaseBuilder> R whereNotExists(T subQuery) {
        this.getWheres().add(new WhereExist(false, subQuery));
        return (R)this;
    }

    default public <T extends BaseBuilder> R orWhereExists(T subQuery) {
        this.getWheres().add(new WhereExist(subQuery, WhereOperator.OR));
        return (R)this;
    }

    default public <T extends BaseBuilder> R orWhereNotExists(T subQuery) {
        this.getWheres().add(new WhereExist(false, subQuery, WhereOperator.OR));
        return (R)this;
    }
}

