/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.jupiter;

import com.amazonaws.client.builder.AwsClientBuilder;
import java.util.Objects;

public class LocalS3Endpoint {
    private final int port;
    private final String endpoint;
    private final String region;

    public LocalS3Endpoint(int port) {
        this.port = port;
        this.region = "local";
        this.endpoint = "http://localhost:" + port;
    }

    public int port() {
        return this.port;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String region() {
        return this.region;
    }

    public AwsClientBuilder.EndpointConfiguration toAmazonS3EndpointConfiguration() {
        return new AwsClientBuilder.EndpointConfiguration(this.endpoint, this.region);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalS3Endpoint that = (LocalS3Endpoint)o;
        return this.port == that.port && Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.region, that.region);
    }

    public int hashCode() {
        return Objects.hash(this.port, this.endpoint, this.region);
    }
}

