/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.jupiter.extensions;

import java.lang.reflect.Method;
import java.util.Objects;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public abstract class AbstractLocalS3ParameterResolver
implements ParameterResolver {
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return Objects.equals(this.className(), parameterContext.getParameter().getType().getName());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        String methodName = context.getTestMethod().map(Method::toString).orElse("");
        String s3OnMethodKey = context.getRequiredTestClass() + methodName + ".LocalS3.Port";
        String s3OnClassKey = context.getRequiredTestClass() + ".LocalS3.Port";
        ExtensionContext.Store store = context.getStore(ExtensionContext.Namespace.GLOBAL);
        Integer port = (Integer)store.getOrDefault((Object)s3OnMethodKey, Integer.TYPE, (Object)((Integer)store.getOrDefault((Object)s3OnClassKey, Integer.TYPE, null)));
        if (null == port) {
            throw new IllegalStateException("You need to add the @LocalS3 annotation on your test class or test method to inject a AmazonS3 instance.");
        }
        return this.resolve(port);
    }

    protected abstract String className();

    protected abstract Object resolve(int var1);
}

