/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.jupiter.extensions;

import com.robothy.s3.jupiter.LocalS3;
import com.robothy.s3.jupiter.supplier.DataPathSupplier;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.util.Objects;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalS3Extension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private static final Logger logger = LoggerFactory.getLogger(LocalS3Extension.class);
    private static final ThreadLocal<com.robothy.s3.rest.LocalS3> localS3ForAll = new ThreadLocal();
    private static final ThreadLocal<com.robothy.s3.rest.LocalS3> localS3ForEach = new ThreadLocal();
    public static final String LOCAL_S3_PORT_STORE_SUFFIX = ".LocalS3.Port";

    public void beforeAll(ExtensionContext context) throws Exception {
        LocalS3 s3Config = context.getRequiredTestClass().getAnnotation(LocalS3.class);
        if (s3Config != null) {
            com.robothy.s3.rest.LocalS3 localS3 = this.launch(s3Config);
            localS3ForAll.set(localS3);
            String key = context.getRequiredTestClass() + LOCAL_S3_PORT_STORE_SUFFIX;
            context.getStore(ExtensionContext.Namespace.GLOBAL).put((Object)key, (Object)localS3.getPort());
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        Method testMethod = context.getRequiredTestMethod();
        LocalS3 s3Config = testMethod.getAnnotation(LocalS3.class);
        if (s3Config != null) {
            com.robothy.s3.rest.LocalS3 localS3 = this.launch(s3Config);
            localS3ForEach.set(localS3);
            String key = context.getRequiredTestClass() + context.getRequiredTestMethod() + LOCAL_S3_PORT_STORE_SUFFIX;
            context.getStore(ExtensionContext.Namespace.GLOBAL).put((Object)key, (Object)localS3.getPort());
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (Objects.nonNull(localS3ForEach.get())) {
            this.shutdown(localS3ForEach.get());
            localS3ForEach.remove();
            String key = context.getRequiredTestClass() + context.getRequiredTestMethod() + LOCAL_S3_PORT_STORE_SUFFIX;
            context.getStore(ExtensionContext.Namespace.GLOBAL).remove((Object)key);
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        if (Objects.nonNull(localS3ForAll.get())) {
            this.shutdown(localS3ForAll.get());
            localS3ForAll.remove();
        }
    }

    private com.robothy.s3.rest.LocalS3 launch(LocalS3 s3Config) {
        String dataPath;
        int port = s3Config.port();
        if (port == -1) {
            port = this.findFreeTcpPort();
        }
        if (StringUtils.isBlank((String)(dataPath = s3Config.dataPath())) && s3Config.dataPathSupplier() != DataPathSupplier.class) {
            try {
                Constructor<? extends DataPathSupplier> constructor = s3Config.dataPathSupplier().getDeclaredConstructor(new Class[0]);
                DataPathSupplier dataPathSupplier = constructor.newInstance(new Object[0]);
                dataPath = (String)dataPathSupplier.get();
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("You must define no-args constructor in " + s3Config.dataPathSupplier());
            }
        }
        com.robothy.s3.rest.LocalS3 localS3 = com.robothy.s3.rest.LocalS3.builder().port(port).dataPath(StringUtils.isBlank((String)dataPath) ? null : dataPath).mode(s3Config.mode()).initialDataCacheEnabled(s3Config.initialDataCacheEnabled()).build();
        localS3.start();
        logger.debug("LocalS3 endpoint http://localhost:" + port);
        return localS3;
    }

    private void shutdown(com.robothy.s3.rest.LocalS3 localS3) {
        localS3.shutdown();
    }

    private int findFreeTcpPort() {
        int freePort;
        try (ServerSocket serverSocket = new ServerSocket(0);){
            freePort = serverSocket.getLocalPort();
        }
        catch (IOException e) {
            throw new IllegalStateException("TCP port is not available.");
        }
        return freePort;
    }
}

