/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.assertions;

import com.robothy.netty.http.HttpRequest;
import java.util.Optional;

public class RequestAssertions {
    public static String assertBucketNameProvided(HttpRequest request) {
        return (String)request.parameter("bucket").orElseThrow(() -> new IllegalArgumentException("Bucket name must be provided in request path. You may need to make the Amazon S3 client using path style via 'AmazonS3ClientBuilder#withPathStyleAccessEnabled(true)' or ClientConfiguration()#withDisableHostPrefixInjection(true)."));
    }

    public static String assertObjectKeyProvided(HttpRequest request) {
        return request.parameter("key").map(key -> key.startsWith("/") ? key.substring(1) : key).orElseThrow(() -> new IllegalArgumentException("The object key is required."));
    }

    public static Optional<Character> assertDelimiterIsValid(HttpRequest request) {
        return request.parameter("delimiter").map(delimiter -> {
            if (delimiter.length() != 1) {
                throw new IllegalArgumentException("Invalid delimiter. The delimiter must be a character.");
            }
            return Character.valueOf(delimiter.charAt(0));
        });
    }

    public static Optional<String> assertEncodingTypeIsValid(HttpRequest request) {
        return request.parameter("encoding-type").map(encodingType -> {
            if (!"url".equalsIgnoreCase((String)encodingType)) {
                throw new IllegalArgumentException("Invalid encoding-type. The valid value is 'url'.");
            }
            return encodingType;
        });
    }

    public static int assertPartNumberIsValid(HttpRequest request) {
        String partNumber = (String)request.parameter("partNumber").orElseThrow(() -> new IllegalArgumentException("'partNumber' is required."));
        int number = Integer.parseInt(partNumber);
        if (number < 1 || number > 10000) {
            throw new IllegalArgumentException("The 'partNumber' must be a positive integer between 1 and 10000");
        }
        return number;
    }

    public static String assertUploadIdIsProvided(HttpRequest request) {
        return (String)request.parameter("uploadId").orElseThrow(() -> new IllegalArgumentException("'uploadId' is required."));
    }

    public static String assertUserMetadataHeaderIsValid(String userMetaHeaderName) {
        if (!userMetaHeaderName.startsWith("x-amz-meta-") || userMetaHeaderName.length() == "x-amz-meta-".length()) {
            throw new IllegalArgumentException("Invalid user-defined object metadata key: " + userMetaHeaderName + ".");
        }
        return userMetaHeaderName.substring("x-amz-meta-".length()).toLowerCase();
    }
}

