/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.handler;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.robothy.netty.http.HttpRequest;
import com.robothy.netty.http.HttpRequestHandler;
import com.robothy.netty.http.HttpResponse;
import com.robothy.s3.core.service.BucketService;
import com.robothy.s3.datatypes.VersioningConfiguration;
import com.robothy.s3.rest.assertions.RequestAssertions;
import com.robothy.s3.rest.service.ServiceFactory;
import com.robothy.s3.rest.utils.ResponseUtils;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.InputStream;

class PutBucketVersioningController
implements HttpRequestHandler {
    private final BucketService bucketService;
    private final XmlMapper xmlMapper;

    PutBucketVersioningController(ServiceFactory serviceFactory) {
        this.bucketService = serviceFactory.getInstance(BucketService.class);
        this.xmlMapper = serviceFactory.getInstance(XmlMapper.class);
    }

    public void handle(HttpRequest request, HttpResponse response) throws Exception {
        String bucketName = RequestAssertions.assertBucketNameProvided(request);
        ByteBufInputStream requestBody = new ByteBufInputStream(request.getBody());
        VersioningConfiguration versioningConfiguration = (VersioningConfiguration)this.xmlMapper.readValue((InputStream)requestBody, VersioningConfiguration.class);
        boolean versioningEnabled = "Enabled".equals(versioningConfiguration.getStatus());
        this.bucketService.setVersioningEnabled(bucketName, versioningEnabled);
        response.status(HttpResponseStatus.OK);
        ResponseUtils.addDateHeader(response);
        ResponseUtils.addAmzRequestId(response);
    }
}

