/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.handler;

import com.robothy.netty.http.HttpRequest;
import com.robothy.netty.http.HttpRequestHandler;
import com.robothy.netty.http.HttpResponse;
import com.robothy.s3.core.service.BucketService;
import com.robothy.s3.rest.assertions.RequestAssertions;
import com.robothy.s3.rest.service.ServiceFactory;
import com.robothy.s3.rest.utils.ResponseUtils;
import io.netty.handler.codec.http.HttpResponseStatus;

class HeadBucketController
implements HttpRequestHandler {
    private final BucketService bucketService;

    HeadBucketController(ServiceFactory serviceFactory) {
        this.bucketService = serviceFactory.getInstance(BucketService.class);
    }

    public void handle(HttpRequest request, HttpResponse response) throws Exception {
        String bucketName = RequestAssertions.assertBucketNameProvided(request);
        this.bucketService.getBucket(bucketName);
        response.status(HttpResponseStatus.OK).putHeader("x-amz-bucket-region", (Object)"local");
        ResponseUtils.addAmzRequestId(response);
        ResponseUtils.addDateHeader(response);
        ResponseUtils.addServerHeader(response);
    }
}

