/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class AwsChunkedDecodingInputStream
extends InputStream {
    private static final int MAX_CHUNK_SIZE = 262144;
    private static final byte[] CRLF = "\r\n".getBytes(StandardCharsets.UTF_8);
    private static final byte[] DELIMITER = ";".getBytes(StandardCharsets.UTF_8);
    private final InputStream source;
    private int remainingInChunk = 0;
    private final ByteBuffer byteBuffer = ByteBuffer.allocate(262144);

    AwsChunkedDecodingInputStream(InputStream source) {
        this.source = source;
    }

    @Override
    public int read() throws IOException {
        if (this.remainingInChunk == 0) {
            byte[] hexLengthBytes = this.readUntil(DELIMITER);
            if (hexLengthBytes == null) {
                return -1;
            }
            this.remainingInChunk = Integer.parseInt(new String(hexLengthBytes, StandardCharsets.UTF_8).trim(), 16);
            if (this.remainingInChunk == 0) {
                return -1;
            }
            this.readUntil(CRLF);
        }
        --this.remainingInChunk;
        return this.source.read();
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    private byte[] readUntil(byte[] endSequence) throws IOException {
        this.byteBuffer.clear();
        while (!this.endsWith(this.byteBuffer.asReadOnlyBuffer(), endSequence)) {
            int c = this.source.read();
            if (c < 0) {
                return null;
            }
            byte unsigned = (byte)(c & 0xFF);
            this.byteBuffer.put(unsigned);
        }
        byte[] result = new byte[this.byteBuffer.position() - endSequence.length];
        this.byteBuffer.rewind();
        this.byteBuffer.get(result);
        return result;
    }

    private boolean endsWith(ByteBuffer buffer, byte[] endSequence) {
        int pos = buffer.position();
        if (pos >= endSequence.length) {
            for (int i = 0; i < endSequence.length; ++i) {
                if (buffer.get(pos - endSequence.length + i) == endSequence[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

