/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.handler;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.robothy.netty.http.HttpRequest;
import com.robothy.netty.http.HttpRequestHandler;
import com.robothy.netty.http.HttpResponse;
import com.robothy.s3.core.model.request.CreateMultipartUploadOptions;
import com.robothy.s3.core.service.CreateMultipartUploadService;
import com.robothy.s3.core.service.ObjectService;
import com.robothy.s3.rest.assertions.RequestAssertions;
import com.robothy.s3.rest.model.response.InitiateMultipartUploadResult;
import com.robothy.s3.rest.service.ServiceFactory;
import com.robothy.s3.rest.utils.RequestUtils;
import com.robothy.s3.rest.utils.ResponseUtils;
import io.netty.handler.codec.http.HttpResponseStatus;

class CreateMultipartUploadController
implements HttpRequestHandler {
    private final CreateMultipartUploadService uploadService;
    private final XmlMapper xmlMapper;

    CreateMultipartUploadController(ServiceFactory serviceFactory) {
        this.uploadService = (CreateMultipartUploadService)serviceFactory.getInstance(ObjectService.class);
        this.xmlMapper = serviceFactory.getInstance(XmlMapper.class);
    }

    public void handle(HttpRequest request, HttpResponse response) throws Exception {
        String bucket = RequestAssertions.assertBucketNameProvided(request);
        String key = RequestAssertions.assertObjectKeyProvided(request);
        String contentType = request.parameter("content-type").orElse("octet/stream");
        String uploadId = this.uploadService.createMultipartUpload(bucket, key, CreateMultipartUploadOptions.builder().tagging((String[][])RequestUtils.extractTagging(request).orElse(null)).contentType(contentType).build());
        InitiateMultipartUploadResult result = InitiateMultipartUploadResult.builder().bucket(bucket).key(key).uploadId(uploadId).build();
        response.status(HttpResponseStatus.OK).write(this.xmlMapper.writeValueAsString((Object)result));
        ResponseUtils.addDateHeader(response);
        ResponseUtils.addServerHeader(response);
        ResponseUtils.addAmzRequestId(response);
    }
}

