/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.handler;

import com.robothy.netty.http.HttpRequest;
import com.robothy.netty.http.HttpRequestHandler;
import com.robothy.netty.http.HttpResponse;
import com.robothy.s3.core.service.BucketService;
import com.robothy.s3.rest.assertions.RequestAssertions;
import com.robothy.s3.rest.service.ServiceFactory;
import com.robothy.s3.rest.utils.ResponseUtils;
import io.netty.handler.codec.http.HttpResponseStatus;

class DeleteBucketController
implements HttpRequestHandler {
    private final BucketService bucketService;

    DeleteBucketController(ServiceFactory serviceFactory) {
        this.bucketService = serviceFactory.getInstance(BucketService.class);
    }

    public void handle(HttpRequest request, HttpResponse response) throws Exception {
        String bucketName = RequestAssertions.assertBucketNameProvided(request);
        this.bucketService.deleteBucket(bucketName);
        response.status(HttpResponseStatus.NO_CONTENT);
        ResponseUtils.addDateHeader(response);
        ResponseUtils.addServerHeader(response);
        ResponseUtils.addAmzRequestId(response);
    }
}

