/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.utils;

import com.robothy.netty.http.HttpResponse;
import com.robothy.s3.core.util.IdUtils;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public class ResponseUtils {
    public static void addDateHeader(HttpResponse response) {
        response.putHeader(HttpHeaderNames.DATE.toString(), (Object)DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now(ZoneOffset.UTC)));
    }

    public static void addAmzRequestId(HttpResponse response) {
        response.putHeader("x-amz-request-id", (Object)IdUtils.nextUuid());
    }

    public static void addServerHeader(HttpResponse response) {
        response.putHeader(HttpHeaderNames.SERVER.toString(), (Object)"LocalS3");
    }

    public static void addETag(HttpResponse response, String etag) {
        if (Objects.nonNull(etag)) {
            response.putHeader(HttpHeaderNames.ETAG.toString(), (Object)etag);
        }
    }

    public static HttpResponse addCommonHeaders(HttpResponse response) {
        ResponseUtils.addDateHeader(response);
        ResponseUtils.addAmzRequestId(response);
        ResponseUtils.addServerHeader(response);
        return response;
    }
}

