/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.handler;

import com.robothy.netty.http.HttpRequest;
import com.robothy.netty.http.HttpRequestHandler;
import com.robothy.netty.http.HttpResponse;
import com.robothy.s3.core.service.ObjectService;
import com.robothy.s3.rest.assertions.RequestAssertions;
import com.robothy.s3.rest.service.ServiceFactory;
import com.robothy.s3.rest.utils.ResponseUtils;
import io.netty.handler.codec.http.HttpResponseStatus;

public class AbortMultipartUploadController
implements HttpRequestHandler {
    private final ObjectService objectService;

    public AbortMultipartUploadController(ServiceFactory serviceFactory) {
        this.objectService = serviceFactory.getInstance(ObjectService.class);
    }

    public void handle(HttpRequest request, HttpResponse response) throws Exception {
        String bucketName = RequestAssertions.assertBucketNameProvided(request);
        String objectKey = RequestAssertions.assertObjectKeyProvided(request);
        String uploadId = RequestAssertions.assertUploadIdIsProvided(request);
        this.objectService.abortMultipartUpload(bucketName, objectKey, uploadId);
        response.status(HttpResponseStatus.NO_CONTENT);
        ResponseUtils.addCommonHeaders(response);
    }
}

