/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.utils;

import com.robothy.netty.http.HttpRequest;
import com.robothy.s3.core.exception.LocalS3InvalidArgumentException;
import com.robothy.s3.rest.assertions.RequestAssertions;
import com.robothy.s3.rest.model.request.DecodedAmzRequestBody;
import com.robothy.s3.rest.utils.AwsChunkedDecodingInputStream;
import com.robothy.s3.rest.utils.InputStreamUtils;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class RequestUtils {
    @Deprecated
    public static InputStream getInputStream(HttpRequest request) {
        ByteBufInputStream inputStream = new ByteBufInputStream(request.getBody());
        if (request.header((CharSequence)"x-amz-content-sha256").map("STREAMING-AWS4-HMAC-SHA256-PAYLOAD"::equals).orElse(false).booleanValue()) {
            return InputStreamUtils.decodeAwsChunkedEncodingInputStream((InputStream)inputStream);
        }
        return inputStream;
    }

    public static DecodedAmzRequestBody getBody(HttpRequest request) {
        DecodedAmzRequestBody result = new DecodedAmzRequestBody();
        if (request.header((CharSequence)"x-amz-content-sha256").map("STREAMING-AWS4-HMAC-SHA256-PAYLOAD"::equals).orElse(false).booleanValue()) {
            result.setDecodedBody(new AwsChunkedDecodingInputStream((InputStream)new ByteBufInputStream(request.getBody())));
            result.setDecodedContentLength(request.header((CharSequence)"x-amz-decoded-content-length").map(Long::parseLong).orElseThrow(() -> new IllegalArgumentException("x-amz-decoded-content-lengthheader not exist.")));
        } else {
            result.setDecodedBody((InputStream)new ByteBufInputStream(request.getBody()));
            result.setDecodedContentLength(request.header((CharSequence)HttpHeaderNames.CONTENT_LENGTH.toString()).map(Long::parseLong).orElseThrow(() -> new IllegalArgumentException("Content-Type is required.")));
        }
        return result;
    }

    public static Optional<String> getETag(HttpRequest request) {
        return request.header((CharSequence)HttpHeaderNames.ETAG.toString());
    }

    public static Optional<String[][]> extractTagging(HttpRequest request) {
        String tagging;
        Optional taggingOpt = request.header((CharSequence)"x-amz-tagging");
        if (taggingOpt.isEmpty() || StringUtils.isBlank((CharSequence)(tagging = (String)taggingOpt.get()))) {
            return Optional.empty();
        }
        String[] tags = tagging.split("&");
        String[][] tagSet = new String[tags.length][2];
        for (int i = 0; i < tags.length; ++i) {
            String[] kv = tags[i].split("=");
            if (kv.length != 2) {
                throw new LocalS3InvalidArgumentException("x-amz-tagging", "Invalid tagging format.");
            }
            tagSet[i][0] = kv[0];
            tagSet[i][1] = kv[1];
        }
        return Optional.of(tagSet);
    }

    public static Map<String, String> extractUserMetadata(HttpRequest request) {
        HashMap<String, String> userMetadata = new HashMap<String, String>();
        request.getHeaders().forEach((k, v) -> {
            if (k.toString().startsWith("x-amz-meta-")) {
                String metaName = RequestAssertions.assertUserMetadataHeaderIsValid(k.toString());
                userMetadata.put(metaName, (String)v);
            }
        });
        return userMetadata;
    }
}

