/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest.handler;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.robothy.netty.http.HttpRequest;
import com.robothy.netty.http.HttpRequestHandler;
import com.robothy.netty.http.HttpResponse;
import com.robothy.s3.core.service.BucketService;
import com.robothy.s3.core.util.IdUtils;
import com.robothy.s3.datatypes.request.CreateBucketConfiguration;
import com.robothy.s3.datatypes.response.CreateBucketResult;
import com.robothy.s3.rest.assertions.RequestAssertions;
import com.robothy.s3.rest.service.ServiceFactory;
import com.robothy.s3.rest.utils.ResponseUtils;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.io.InputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CreateBucketController
implements HttpRequestHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CreateBucketController.class);
    BucketService bucketService;
    XmlMapper xmlMapper;

    CreateBucketController(ServiceFactory serviceFactory) {
        this.bucketService = serviceFactory.getInstance(BucketService.class);
        this.xmlMapper = serviceFactory.getInstance(XmlMapper.class);
    }

    public void handle(HttpRequest request, HttpResponse response) throws Exception {
        ByteBufInputStream inputStream = new ByteBufInputStream(request.getBody());
        String locationConstraint = "local";
        if (request.getBody().readableBytes() != 0) {
            CreateBucketConfiguration createBucketConfig = (CreateBucketConfiguration)this.xmlMapper.readValue((InputStream)inputStream, CreateBucketConfiguration.class);
            locationConstraint = createBucketConfig.getLocationConstraint();
        }
        String bucketName = RequestAssertions.assertBucketNameProvided(request);
        this.bucketService.createBucket(bucketName, locationConstraint);
        CreateBucketResult createBucketResult = CreateBucketResult.builder().bucketArn(IdUtils.nextUuid()).build();
        response.putHeader("Location", (Object)"local").putHeader(HttpHeaderNames.CONTENT_TYPE.toString(), (Object)HttpHeaderValues.APPLICATION_XML).write(this.xmlMapper.writeValueAsString((Object)createBucketResult));
        ResponseUtils.addDateHeader(response);
        ResponseUtils.addAmzRequestId(response);
    }
}

