/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.rest;

import com.ctc.wstx.stax.WstxInputFactory;
import com.ctc.wstx.stax.WstxOutputFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.robothy.netty.initializer.HttpServerInitializer;
import com.robothy.s3.core.service.BucketService;
import com.robothy.s3.core.service.ObjectService;
import com.robothy.s3.core.service.manager.LocalS3Manager;
import com.robothy.s3.rest.handler.LocalS3RouterFactory;
import com.robothy.s3.rest.service.ServiceFactory;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import java.nio.file.Path;
import java.util.Objects;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalS3 {
    private static final Logger log = LoggerFactory.getLogger(LocalS3.class);
    private int port = 8080;
    private Path dataDirectory;
    private int nettyParentEventGroupThreadNum = 1;
    private int nettyChildEventGroupThreadNum = 2;
    private int s3ExecutorThreadNum = 4;
    private NioEventLoopGroup parentGroup;
    private NioEventLoopGroup childGroup;
    private EventExecutorGroup executorGroup;
    private Channel serverSocketChannel;

    public static Builder builder() {
        return new Builder();
    }

    public void start() {
        this.registerServices();
        this.parentGroup = new NioEventLoopGroup(this.nettyParentEventGroupThreadNum);
        this.childGroup = new NioEventLoopGroup(this.nettyChildEventGroupThreadNum);
        this.executorGroup = new DefaultEventLoopGroup(this.s3ExecutorThreadNum);
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ChannelFuture channelFuture = ((ServerBootstrap)((ServerBootstrap)serverBootstrap.group((EventLoopGroup)this.parentGroup, (EventLoopGroup)this.childGroup).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new HttpServerInitializer(this.executorGroup, LocalS3RouterFactory.create())).bind(this.port).sync();
        log.info("LocalS3 started.");
        this.serverSocketChannel = channelFuture.channel();
    }

    private void registerServices() {
        LocalS3Manager manager = Objects.nonNull(this.dataDirectory) ? LocalS3Manager.createFileSystemS3Manager((Path)this.dataDirectory) : LocalS3Manager.createInMemoryS3Manager();
        BucketService bucketService = manager.bucketService();
        ObjectService objectService = manager.objectService();
        ServiceFactory.register(BucketService.class, () -> bucketService);
        ServiceFactory.register(ObjectService.class, () -> objectService);
        WstxInputFactory input = new WstxInputFactory();
        input.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        XmlMapper xmlMapper = new XmlMapper(new XmlFactory((XMLInputFactory)input, (XMLOutputFactory)new WstxOutputFactory()));
        xmlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ServiceFactory.register(XmlMapper.class, () -> xmlMapper);
    }

    public void shutdown() {
        if (null == this.parentGroup || null == this.childGroup) {
            throw new IllegalStateException("LocalS3 is not started.");
        }
        try {
            this.serverSocketChannel.close().sync();
            log.info("LocalS3 stopped.");
        }
        catch (InterruptedException e) {
            log.error("Close server socket channel failed.", (Throwable)e);
        }
        finally {
            this.executorGroup.shutdownGracefully();
            this.childGroup.shutdownGracefully();
            this.parentGroup.shutdownGracefully();
        }
    }

    public int getPort() {
        return this.port;
    }

    public Path getDataDirectory() {
        return this.dataDirectory;
    }

    public static class Builder {
        private final LocalS3 propHolder = new LocalS3();

        public Builder port(int port) {
            this.propHolder.port = port;
            return this;
        }

        public Builder dataDirectory(Path dataDirectory) {
            this.propHolder.dataDirectory = dataDirectory;
            return this;
        }

        public Builder nettyParentEventGroupThreadNum(int nettyParentEventGroupThreadNum) {
            this.propHolder.nettyParentEventGroupThreadNum = nettyParentEventGroupThreadNum;
            return this;
        }

        public Builder nettyChildEventGroupThreadNum(int nettyChildEventGroupThreadNum) {
            this.propHolder.nettyChildEventGroupThreadNum = nettyChildEventGroupThreadNum;
            return this;
        }

        public Builder s3ExecutorThreadNum(int s3ExecutorThreadNum) {
            this.propHolder.s3ExecutorThreadNum = s3ExecutorThreadNum;
            return this;
        }

        public LocalS3 build() {
            LocalS3 localS3 = new LocalS3();
            localS3.port = this.propHolder.port;
            localS3.dataDirectory = this.propHolder.dataDirectory;
            localS3.nettyParentEventGroupThreadNum = this.propHolder.nettyParentEventGroupThreadNum;
            localS3.nettyChildEventGroupThreadNum = this.propHolder.nettyChildEventGroupThreadNum;
            localS3.s3ExecutorThreadNum = this.propHolder.s3ExecutorThreadNum;
            return localS3;
        }
    }
}

